/*.P.D ar metodeem
Jelgavas tehnikums, 110.grupa
Veidoja: Alise Ragucka-Ragovska (Negribēju mocīties ar savu otru uzvārdu tapec tur ir vienk RaguckaR T-T)
Veidots: 01/04/2025. Online C# compilerā programiz.com*/

using System;

class Program
{
    static void Main()
    {
        int[,] dati = {
            { 1, 2, 3, 4 },
            { 5, 6, 7, 8 },
            { 9, 10, 11, 12 }};

        int[,] aridati = GenerateRandomArray(3, 4, 1, 100); //ģenerē nejaušu masīvu ar skaitļiem no 1 līdz 100

        TabulaDati("Alise", dati); //izvada pirmo tabulu
        TabulaDati("RaguckaR", aridati); //izvada otro tabulu
    }

    static void TabulasLinija(int skaits, int xtimes)
    {
        string line = new string('-', skaits); //izveido atkārtotu "-" virkni
        for (int i = 0; i < xtimes; i++)
        {
            Console.Write("*" + line); //izvada rindiņu ar "*" sākumā
        }
        Console.WriteLine("*"); //pieliek noslēdzošo "*"
    }

    static void TabulaDati(string virsraksts, int[,] dati)
    {
        Console.WriteLine(virsraksts); //izvada tabulas virsrakstu
        TabulasLinija(5, 4); //izvada līniju pirms galvenes
        TabulasGalva("Alise"); //izvada tabulas galveni
        TabulasLinija(5, 7); //izvada līniju pēc galvenes

        for (int i = 0; i < dati.GetLength(0); i++)
        {
            int max = int.MinValue, min = int.MaxValue, sum = 0; //sākuma vērtības statistikai
            int[] row = dati.GetRow(i); //paņem rindu no masīva
            
            foreach (var val in row)
            {
                Console.Write($"| {val,3} "); //izvada skaitli rindā ar atstarpi
                max = Math.Max(max, val); //atrod lielāko skaitli rindā
                min = Math.Min(min, val); //atrod mazāko skaitli rindā
                sum += val; //saskaita visu rindu kopā
            }
            Console.WriteLine($"| {max,3} | {min,3} | {sum,5} |"); //izvada aprēķinātos datus
        }
        TabulasLinija(3, 11); //izvada noslēguma līniju tabulai
    }

    static void TabulasGalva(string vards)
    {
        Console.WriteLine($"|{vards}| max | min | sum |"); //izvada tabulas galvenes tekstu
    }

    static int[,] TabulasMaina(int[,] dati)
    {
        int rows = dati.GetLength(0), cols = dati.GetLength(1);
        int[,] newData = new int[cols, rows]; //izveido jaunu masīvu ar apgrieztiem izmēriem
        
        for (int i = 0; i < rows; i++)
        {
            for (int j = 0; j < cols; j++)
            {
                newData[j, i] = dati[i, j]; //apmaina rindas ar kolonnām
            }
        }
        return newData; //atgriež apgriezto masīvu
    }

    static int[,] GenerateRandomArray(int rows, int cols, int minValue, int maxValue)
    {
        Random rand = new Random(); //izveido jaunu nejaušo skaitļu ģeneratoru
        int[,] randomArray = new int[rows, cols]; //izveido divdimensiju masīvu
        
        for (int i = 0; i < rows; i++)
        {
            for (int j = 0; j < cols; j++)
            {
                randomArray[i, j] = rand.Next(minValue, maxValue + 1); //ģenerē nejaušu skaitli noteiktajā diapazonā
            }
        }
        return randomArray; //atgriež izveidoto masīvu
    }
}

public static class ArrayExtensions
{
    public static int[] GetRow(this int[,] array, int rowIndex)
    {
        int length = array.GetLength(1);
        int[] row = new int[length]; //izveido masīvu rindas datiem
        
        for (int i = 0; i < length; i++)
        {
            row[i] = array[rowIndex, i]; //paņem skaitļus no attiecīgās rindas
        }
        return row; //atgriež rindu kā vienu masīvu
    }
}
