/*.P.D failu sistemas taisisana :p
Jelgavas tehnikums, 110.grupa
Veidoja: Alise Ragucka-Ragovska
Veidots: 10/05/2025. Online C# compilerā programiz.com* ar AI un w3schools mix palidzibu :) */

using System;
using System.Collections.Generic;


class Program
{
    // Klase kas parstave direktoriju vai failu
    public class FSNode
    {
        public string Label { get; set; } // Nosaukums failam vai direktorijai
        public FSNode Container { get; set; } // Vecaks mezgls
        public List<FSNode> Items { get; set; } = new List<FSNode>(); // Berni mezgli
        public bool Folder { get; set; } // Vai tas ir direktorija

        // Konstruktors kas uzstada nosaukumu un tipu
        public FSNode(string label, bool isFolder)
        {
            Label = label;
            Folder = isFolder;
        }

        // Pieskir sevi jaunam vecakam un iznem no veca
        public void Relocate(FSNode newParent)
        {
            if (Container != null)
            {
                Container.Items.Remove(this); // Izvaco no vecaka saraksta
            }
            Container = newParent; // Jauns vecaks
            newParent.Items.Add(this); // Pievieno sevi jaunajam vecakam
        }

        // Attelo sevi un bernus ja direktorija
        public void Display()
        {
            if (Folder)
            {
                Console.WriteLine("/" + Label); // Parada direktorijas nosaukumu
                foreach (var item in Items)
                {
                    Console.WriteLine(" /" + item.Label); // Parada bernu nosaukumus
                }
            }
            else
            {
                Console.WriteLine("~" + Label); // Parada failu
            }
        }

        // Dzest objektu no vecaka
        public void Remove()
        {
            if (Folder && Items.Count > 0)
            {
                Console.WriteLine($"Vai tiesam velies dzest /{Label}/ un visu saturu y n"); // Apstiprinajums
                var input = Console.ReadLine();
                if (input?.ToLower() == "y")
                {
                    foreach (var item in new List<FSNode>(Items))
                    {
                        item.Remove(); // Rekursiva dzesana
                    }
                    Container?.Items.Remove(this); // Dzest sevi no vecaka
                }
            }
            else
            {
                Container?.Items.Remove(this); // Dzest sevi ja nav bernu
            }
        }

        // Pievienot bernu mezglu ja vel nav ar tadu nosaukumu
        public void Insert(FSNode child)
        {
            if (!Items.Exists(c => c.Label == child.Label))
            {
                Items.Add(child); // Pievieno bernu
                child.Container = this; // Norada vecaku
            }
            else
            {
                Console.WriteLine($"Objekts ar nosaukumu /{child.Label}/ jau eksiste"); // Nosaukums aiznemts
            }
        }
    }

    // Failu sistemas galvena klase
    class FSManager
    {
        public FSNode Root { get; set; } // Sakne
        public FSNode Location { get; set; } // Pašreizēja atrašanas vieta

        // Inicē saknes direktoriju
        public FSManager()
        {
            Root = new FSNode("diska", true);
            Location = Root;
        }

        // Izveido jaunu mapi
        public void NewFolder(string name)
        {
            var folder = new FSNode(name, true);
            Location.Insert(folder);
        }

        // Izveido jaunu failu
        public void NewFile(string name)
        {
            var file = new FSNode(name, false);
            Location.Insert(file);
        }

        // Maina aktivas direktorijas vietu
        public void GoTo(string name)
        {
            var next = Location.Items.Find(c => c.Label == name && c.Folder);
            if (next != null)
            {
                Location = next; // Ienak mape
            }
            else
            {
                Console.WriteLine("Mape nav atrasta"); // Nepareizs nosaukums
            }
        }

        // Paradit satura atrasanas vieta
        public void List()
        {
            Console.WriteLine($"Tagadeja vieta /{Location.Label}/");
            foreach (var item in Location.Items)
            {
                item.Display(); // Paradit visus bernus
            }
        }
    }

    // Galvena funkcija
    static void Main(string[] args)
    {
        FSManager manager = new FSManager(); // Inicializet failu sistemu

        while (true)
        {
            manager.List(); // Parada saturu
            Console.Write("C: ");
            string cmd = Console.ReadLine()?.Trim().ToLower(); // Nolasit ievadi

            if (cmd == "exit" || cmd == "by")
            {
                break; // Iziet no cikla
            }

            string[] parts = cmd?.Split(' ');
            switch (parts[0])
            {
                case "mkdir":
                    if (parts.Length > 1)
                    {
                        manager.NewFolder(parts[1]); // Izveido direktoriju
                    }
                    break;

                case "create":
                    if (parts.Length > 1)
                    {
                        manager.NewFile(parts[1]); // Izveido failu
                    }
                    break;

                case "rm":
                    if (parts.Length > 1)
                    {
                        var item = manager.Location.Items.Find(c => c.Label == parts[1]);
                        item?.Remove(); // Dzest objektu
                    }
                    break;

                case "dir":
                    manager.List(); // Parada saturu
                    break;

                case "cd":
                    if (parts.Length > 1)
                    {
                        if (parts[1] == "..")
                        {
                            if (manager.Location.Container != null)
                            {
                                manager.Location = manager.Location.Container; // Iet uz vecaku
                            }
                        }
                        else
                        {
                            manager.GoTo(parts[1]); // Iet uz noradito direktoriju
                        }
                    }
                    break;

                case "edit":
                    if (parts.Length > 1)
                    {
                        var file = manager.Location.Items.Find(c => c.Label == parts[1] && !c.Folder);
                        if (file != null)
                        {
                            Console.WriteLine($"Rediget datni {file.Label}"); // Simule redigesanu
                        }
                        else
                        {
                            Console.WriteLine("Datne nav atrasta"); // Nav fails
                        }
                    }
                    break;

                default:
                    Console.WriteLine("Nezinama komanda"); // Nepareiza ievade
                    break;
            }
        }
    }
}
