/*4.Uzdevums Tabulas aizpilde
Jelgavas tehnikums, 110.grupa
Veidoja: Alise Ragucka-Ragovska (Es negribēju mocīties ar savu otru uzvārdu T-T)
Veidots: 04/03/2025. Online C# compilerā programiz.com*/

using System;
using System.Linq;

class Program
{
    static void Main()
    {
        // Definējam vārdu un uzvārdu
        string vards = "Alise";
        string uzvards = "Ragucksa";

        // Pievienojam "X" sākumā un pārvēršam masīvā
        char[] vardsMasivs = ("X" + vards).ToCharArray();
        char[] uzvardsMasivs = ("X" + uzvards).ToCharArray();

        int simboluSkaits = uzvardsMasivs.Length;

        // Izvada vārdu un tā garumu
        Console.WriteLine($"Mans vārds ir {vards} un tas sastāv no {vards.Length} burtiem.");
        Console.WriteLine($"Mans uzvārds ir {uzvards} un tas sastāv no {uzvards.Length} burtiem.\n");

        // Izveidojam tabulas malu
        string mala = "+---+----+----+----+----+----+----+----+----+----+----+";
        Console.WriteLine(mala);

        // Izvada galveni - burti
        Console.Write("| ");
        foreach (char burts in vardsMasivs)
        {
            Console.Write($"| {burts} ");
        }
        Console.WriteLine("| max | min | vid | sum |");

        Console.WriteLine(mala);

        // Izveidojam Random objektu
        Random rng = new Random();

        // Iterējam cauri katram simbolam no uzvārda masīva
        for (int i = 0; i < simboluSkaits; i++)
        {
            // Ģenerējam 5 nejaušus skaitļus no 5 līdz 19
            int[] skaitli = Enumerable.Range(0, 5).Select(_ => rng.Next(5, 20)).ToArray();

            // Izvada simbolu no uzvārda
            Console.Write($"| {uzvardsMasivs[i]} ");

            // Izvada visus skaitļus ar noformatēšanu
            foreach (int sk in skaitli)
            {
                Console.Write($"| {sk,2} ");
            }

            // Izvada aprēķinātos lielākos, mazākos, vidējos un summu
            Console.WriteLine($"| {skaitli.Max(),2} | {skaitli.Min(),2} | {skaitli.Average(),4:F1} | {skaitli.Sum(),3} |");
        }

        // Izvada tabulas apakšējo malu
        Console.WriteLine(mala);
    }
}