/*3.Uzdevums Tabulas manipulacija
Jelgavas tehnikums, 110.grupa
Veidoja: Alise Ragucka-Ragovska
Veidots: 04/03/2025. Online C# compilerā programiz.com*/

using System;

class TekstaApstrade
{
    static void Main()
    {
        // Pieprasa lietotājam ievadīt tekstu
        Console.Write("Ievadi savu tekstu: ");
        string ievade = Console.ReadLine();

        // Izvada vārdu secības apgrieztu versiju
        Console.WriteLine(ApretizVardus(ievade));

        // Izvada pilnībā apgrieztu tekstu (katrs burts apgriezts)
        Console.WriteLine(ApretizTekstu(ievade));

        // Pakāpeniski atklāj tekstu no centra uz āru
        AtklatNoCentra(ievade);

        // Pakāpeniski aizvieto tekstu ar tukšumiem, sākot no centra
        PakapeniskaDzeshana(ievade);

        // Atklāj tekstu no beigām, samazinot katru reizi par vienu simbolu
        AtklatApgriezti(ievade);
    }

    // Funkcija, kas apgriež vārdu kārtību teikumā
    static string ApretizVardus(string teikums)
    {
        // Sadalām teikumu vārdos
        var vardi = teikums.Split(' ');

        // Apgriežam vārdu secību
        Array.Reverse(vardi);

        // Apvienojam atpakaļ teikumā un nodrošinām, ka pirmais burts ir lielais
        var apvienots = string.Join(" ", vardi);
        return char.ToUpper(apvienots[0]) + apvienots.Substring(1);
    }

    // Funkcija, kas apgriež visu tekstu simbolu līmenī (piemēram: "abc" -> "cba")
    static string ApretizTekstu(string teksts)
    {
        var simboli = teksts.ToCharArray();
        Array.Reverse(simboli); // Apgriež simbolu masīvu
        var apgriezts = new string(simboli);
        return char.ToUpper(apgriezts[0]) + apgriezts.Substring(1); // Pirmais burts lielais
    }

    // Funkcija, kas pakāpeniski izvada tekstu no centra, katru reizi par vienu simbolu vairāk
    static void AtklatNoCentra(string teksts)
    {
        int vidus = teksts.Length / 2;

        for (int i = 0; i <= vidus; i++)
        {
            int no = Math.Max(0, vidus - i);     // Kreisā robeža
            int lidz = Math.Min(teksts.Length - 1, vidus + i); // Labā robeža

            // Izvada rindu ar redzamo daļu centrā, pārējo kā atstarpes
            for (int j = 0; j < teksts.Length; j++)
            {
                if (j >= no && j <= lidz)
                    Console.Write(teksts[j]);
                else
                    Console.Write(" ");
            }
            Console.WriteLine();
        }
    }

    // Funkcija, kas pakāpeniski aizvieto burtus ar atstarpēm, virzoties no centra uz malām
    static void PakapeniskaDzeshana(string teksts)
    {
        char[] simboli = teksts.ToCharArray(); // Pārvērš tekstu simbolu masīvā
        int centrs = teksts.Length / 2;

        int paKreisi = centrs;
        int paLabi = centrs + (teksts.Length % 2 == 0 ? 1 : 0); // Apstrāde atšķiras, ja teksts ir pāra garuma

        // Turpinām, kamēr kreisā vai labā robeža nav izietas
        while (paKreisi >= 0 || paLabi < teksts.Length)
        {
            if (paKreisi >= 0) simboli[paKreisi--] = ' '; // Dzēšam pa kreisi
            if (paLabi < teksts.Length) simboli[paLabi++] = ' '; // Dzēšam pa labi
            Console.WriteLine(new string(simboli)); // Izvadām pašreizējo stāvokli
        }
    }

    // Funkcija, kas pakāpeniski izvada tekstu no beigām, katru reizi par vienu simbolu mazāk
    static void AtklatApgriezti(string teksts)
    {
        for (int i = teksts.Length; i > 0; i--)
        {
            Console.WriteLine(teksts.Substring(i - 1));
        }
    }
}
