/*.P.D par bankas sistemu lkm?
Jelgavas tehnikums, 110.grupa
Veidoja: Alise Ragucka-Ragovska
Veidots: 10/04/2025. Online C# compilerā programiz.com. Veidots ar AI un draudznes palidzibu (teamwork makes the dream work)+un w3schol*/

using System;
using System.Collections.Generic;

// klase kas parstav vienu kontu
class Konts
{
    // statiska vertiba lai katram kontam ir unikals ID
    private static int nakamaisID = 1000;

    // konta dati
    private int kontaID;
    private string ipasnieks;
    private decimal bilance;

    // konstruktors izveido jaunu kontu
    public Konts(string ipasnieks, decimal sakumaSumma)
    {
        this.kontaID = nakamaisID++;
        this.ipasnieks = ipasnieks;
        this.bilance = sakumaSumma;
        Console.WriteLine($"Jauns konts izveidots ID: {kontaID}\n");
    }

    // destruktors paradas kad objekts tiek iznicinats
    ~Konts()
    {
        Console.WriteLine($"Konts ar ID {kontaID} tiek dzests");
    }

    // metode atgriez konta ID
    public int SanemtID() => kontaID;

    // metode pievieno naudu kontam
    public void PievienotNaudu(decimal summa)
    {
        if (summa <= 0)
            throw new ArgumentException("Summai jabut pozitivai");
        bilance += summa;
        Console.WriteLine($"Konta {kontaID} iemaksati {summa} EUR\n");
    }

    // metode iznem naudu no konta
    public void IznemtNaudu(decimal summa)
    {
        if (summa <= 0)
            throw new ArgumentException("Summai jabut pozitivai");
        if (summa > bilance)
            throw new InvalidOperationException("Nepietiek lidzeklu");
        bilance -= summa;
        Console.WriteLine($"No konta {kontaID} iznemti {summa} EUR\n");
    }

    // metode rada konta informaciju
    public void RaditDatus()
    {
        Console.WriteLine($"Konta ID: {kontaID}");
        Console.WriteLine($"Ipasnieks: {ipasnieks}");
        Console.WriteLine($"Bilance: {bilance} EUR\n");
    }
}

// galvena programma kas vada visus kontus
class BankasSistema
{
    // saraksts ar visiem kontiem
    static List<Konts> visiKonti = new List<Konts>();

    // galvena ieejas funkcija
    static void Main()
    {
        while (true)
        {
            // izveles menju
            Console.WriteLine("=== Bankas parvaldibas sistema ===");
            Console.WriteLine("1 Pievienot kontu");
            Console.WriteLine("2 Iemaksa konta");
            Console.WriteLine("3 Izmaksat naudu");
            Console.WriteLine("4 Radit konta info");
            Console.WriteLine("5 Iziet\n");
            Console.Write("Izvele: ");

            string komanda = Console.ReadLine();
            Console.WriteLine();

            try
            {
                switch (komanda)
                {
                    case "1":
                        JaunsKonts(); // pievieno jaunu kontu
                        break;
                    case "2":
                        Iemaksa(); // iemaksa konta
                        break;
                    case "3":
                        Izmaksa(); // izmaksa no konta
                        break;
                    case "4":
                        ApskatitKontu(); // paradit konta info
                        break;
                    case "5":
                        return; // iziet no programmas
                    default:
                        Console.WriteLine("Nepareiza izvele\n");
                        break;
                }
            }
            catch (Exception kluda)
            {
                Console.WriteLine($"Kluda notika {kluda.Message}\n");
            }
        }
    }

    // izveido jaunu kontu
    static void JaunsKonts()
    {
        Console.Write("Ievadiet klienta vardu: ");
        string vards = Console.ReadLine();

        Console.Write("Ievadiet sakuma bilanci: ");
        decimal summa = decimal.Parse(Console.ReadLine());

        Konts jauns = new Konts(vards, summa);
        visiKonti.Add(jauns);
    }

    // meklet kontu pec id
    static Konts MekletKontu()
    {
        Console.Write("Ievadiet konta ID: ");
        int id = int.Parse(Console.ReadLine());

        foreach (var k in visiKonti)
        {
            if (k.SanemtID() == id)
                return k;
        }

        throw new Exception("Konts nav atrasts");
    }

    // veic iemaksu
    static void Iemaksa()
    {
        var konts = MekletKontu();
        Console.Write("Ievadiet iemaksas summu: ");
        decimal iemaksa = decimal.Parse(Console.ReadLine());
        konts.PievienotNaudu(iemaksa);
    }

    // veic izmaksa
    static void Izmaksa()
    {
        var konts = MekletKontu();
        Console.Write("Ievadiet iznemsanas summu: ");
        decimal izmaksa = decimal.Parse(Console.ReadLine());
        konts.IznemtNaudu(izmaksa);
    }

    // rada informaciju par kontu
    static void ApskatitKontu()
    {
        var konts = MekletKontu();
        konts.RaditDatus();
    }
}
