/*Uzdevum ar masiviem
Jelgavas tehnikums, 110.grupa
Veidoja: Alise Ragucka-Ragovska (Es negribēju mocīties ar savu otru uzvārdu T-T)
Veidots: 11/03/2025. Online C# compilerā programiz.com*/

using System;

class Program
{
    static void Main()
    {
        string vards = "Alise";
        string uzvards = "Ragucka";

        // Izveido datu masīvu ar papildus kolonnām summai, min un max vērtībām
        int rows = uzvards.Length + 1; // rindas (1 virsrakstam + uzvārda garums)
        int cols = vards.Length + 4;   // kolonnas (vārda garums + sum, min, max + vēl viena "drošībai")

        int[,] dati = new int[rows, cols];
        Random rnd = new Random();

        // Robežas random skaitļiem - no vārda garuma līdz vārda + uzvārda garumam
        int apaksaRobeza = vards.Length;
        int augsaRobeza = vards.Length + uzvards.Length;

        // Aizpilda matricu ar random skaitļiem, sākot no 1.rindas un 1.kolonnas
        for (int r = 1; r < rows; r++)
        {
            for (int c = 1; c <= vards.Length; c++)
            {
                dati[r, c] = rnd.Next(apaksaRobeza, augsaRobeza + 1);
            }
        }

        // Aprēķina katras rindas summu, minimālo un maksimālo vērtību
        for (int r = 1; r < rows; r++)
        {
            int sum = 0, min = int.MaxValue, max = int.MinValue;

            for (int c = 1; c <= vards.Length; c++)
            {
                int vērtība = dati[r, c];
                sum += vērtība;
                if (vērtība < min) min = vērtība;
                if (vērtība > max) max = vērtība;
            }

            dati[r, cols - 3] = sum;
            dati[r, cols - 2] = min;
            dati[r, cols - 1] = max;
        }

        // Izdrukā pirmo tabulu ar virsrakstiem un aprēķiniem rindās
        Console.WriteLine("\n+----+--------------------+-----+-----+-----+");
        Console.Write("|    |");
        foreach (char burts in vards)
            Console.Write($" {burts,-2} |");
        Console.WriteLine("sum  | min | max |");
        Console.WriteLine("+----+--------------------+-----+-----+-----+");

        for (int r = 1; r < rows; r++)
        {
            Console.Write($"| {uzvards[uzvards.Length - r]}  |");
            for (int c = 1; c <= vards.Length; c++)
                Console.Write($" {dati[r, c],2} |");

            Console.Write($" {dati[r, cols - 3],3} | {dati[r, cols - 2],3} | {dati[r, cols - 1],3} |\n");
        }
        Console.WriteLine("+----+--------------------+-----+-----+-----+");

        // Aprēķina un izdrukā kolonnu kopsavilkumu (sum, min, max)
        string[] apzimejumi = { "sum", "min", "max" };

        for (int k = 0; k < 3; k++)
        {
            Console.Write($"| {apzimejumi[k],-3}|");

            for (int c = 1; c <= vards.Length; c++)
            {
                int sum = 0, min = int.MaxValue, max = int.MinValue;

                for (int r = 1; r < rows; r++)
                {
                    int vērtība = dati[r, c];
                    sum += vērtība;
                    if (vērtība < min) min = vērtība;
                    if (vērtība > max) max = vērtība;
                }

                if (k == 0) Console.Write($" {sum,2} |");
                else if (k == 1) Console.Write($" {min,2} |");
                else Console.Write($" {max,2} |");
            }
            Console.WriteLine("  * |  * |  * |");
        }
        Console.WriteLine("+----+--------------------+-----+-----+-----+");

        // === Otrā tabula - transponētā ===

        int[,] transponets = new int[vards.Length + 1, uzvards.Length + 4];

        // Pārsūta datus uz transponēto matricu
        for (int r = 1; r < rows; r++)
            for (int c = 1; c <= vards.Length; c++)
                transponets[c, r] = dati[r, c];

        // Aprēķina rindas summu, min, max transponētajā matricā
        for (int r = 1; r <= vards.Length; r++)
        {
            int sum = 0, min = int.MaxValue, max = int.MinValue;

            for (int c = 1; c < rows; c++)
            {
                int vērtība = transponets[r, c];
                sum += vērtība;
                if (vērtība < min) min = vērtība;
                if (vērtība > max) max = vērtība;
            }

            transponets[r, uzvards.Length + 1] = sum;
            transponets[r, uzvards.Length + 2] = min;
            transponets[r, uzvards.Length + 3] = max;
        }

        // Izdrukā otro tabulu (transponēto)
        Console.WriteLine("\n+----+------------------------------+-----+-----+-----+");
        Console.Write("| X  |");
        foreach (char burts in uzvards)
            Console.Write($" {burts,-2} |");
        Console.WriteLine("sum  | min | max |");
        Console.WriteLine("+----+------------------------------+-----+-----+-----+");

        for (int r = 1; r <= vards.Length; r++)
        {
            Console.Write($"| {vards[r - 1],-2} |");
            for (int c = 1; c <= uzvards.Length; c++)
                Console.Write($" {transponets[r, c],2} |");

            Console.Write($" {transponets[r, uzvards.Length + 1],3} |");
            Console.Write($" {transponets[r, uzvards.Length + 2],3} |");
            Console.Write($" {transponets[r, uzvards.Length + 3],3} |\n");
        }
        Console.WriteLine("+----+------------------------------+-----+-----+-----+");

        // Kolonnu kopsavilkums otrajā tabulā
        for (int k = 0; k < 3; k++)
        {
            Console.Write($"| {apzimejumi[k],-3}|");

            for (int c = 1; c <= uzvards.Length; c++)
            {
                int sum = 0, min = int.MaxValue, max = int.MinValue;

                for (int r = 1; r <= vards.Length; r++)
                {
                    int vērtība = transponets[r, c];
                    sum += vērtība;
                    if (vērtība < min) min = vērtība;
                    if (vērtība > max) max = vērtība;
                }

                if (k == 0) Console.Write($" {sum,2} |");
                else if (k == 1) Console.Write($" {min,2} |");
                else Console.Write($" {max,2} |");
            }
            Console.WriteLine("  * |  * |  * |");
        }
        Console.WriteLine("+----+------------------------------+-----+-----+-----+");
    }

    // Funkcija, kas pārveido katru otro burtu lielo mazajā vārdā
    static string MainitKatruOtroLielu(string teksts)
    {
        char[] simboli = teksts.ToCharArray();

        for (int i = 0; i < simboli.Length; i++)
        {
            // Pārvērš burtus - pāra pozīcijās lielie, pārējie mazie
            simboli[i] = (i % 2 == 0) ? Char.ToUpper(simboli[i]) : Char.ToLower(simboli[i]);
        }
        return new string(simboli);
    }
}
