<?php
// Iekļauj savienojuma failu
include "conn.php";
$conn = new mysqli($servername, $username, $password, $db);
if ($conn->connect_error) {
  die("Connection failed: " . $conn->connect_error);
}

// Inicializē mainīgos ar tukšām vērtībām
$id = $vards = $uzvards = $dzimsanas_datums = $gadi = $masina = $lidmasina = $transports = $helekopters = "";

// Ja forma atvērta labošanas režīmā (ar ?id=...), izgūst datus no datu bāzes
if (isset($_GET["id"])) {
    $id = $_GET["id"];

    // SQL vaicājums, lai iegūtu konkrētā ieraksta datus
    $sql = "SELECT id, vards, uzvards, dzimsanas_datums, gadi, masina, lidmasina, transports, helekopters FROM form_projekts_VO WHERE id = $id";
    $result = $conn->query($sql);

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $vards = $row["vards"];
        $uzvards = $row["uzvards"];
        $dzimsanas_datums = $row["dzimsanas_datums"];
        $gadi = $row["gadi"];
        $masina = $row["masina"];
        $lidmasina = $row["lidmasina"];
        $transports = $row["transports"];
        $helekopters = $row["helekopters"];
    }
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>ievade</title>
    <style>
        /* Minimal styling, сохраняем дизайн */
        input.error, select.error { background-color: #f8d7da; }
        #resultMsg { margin-top: 10px; font-weight: bold; }
    </style>
</head>
<body>

<form id="personForm" action="save.php" method="get" onsubmit="return validateForm();">
    <fieldset>
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">
        <legend>Personas dati:</legend>

        <label for="vards">Vārds:</label>
        <input type="text" id="vards" name="vards" placeholder="Ievadi personas vārdu!" value="<?php echo htmlspecialchars($vards); ?>"><br>

        <label for="uzvards">Uzvārds:</label>
        <input type="text" id="uzvards" name="uzvards" placeholder="Ievadi personas uzvārdu!" value="<?php echo htmlspecialchars($uzvards); ?>"><br>

        <label for="dzimsanas_datums">Dzimšanas datums:</label>
        <input type="date" id="dzimsanas_datums" name="dzimsanas_datums" value="<?php echo htmlspecialchars($dzimsanas_datums); ?>"><br><br>

        <label>Cik jums ir gadi:</label><br>
        <input type="radio" id="gadi1" name="gadi" value="30" <?php echo ($gadi == 30) ? "checked" : ""; ?>>
        <label for="gadi1">0 - 30</label><br>

        <input type="radio" id="gadi2" name="gadi" value="60" <?php echo ($gadi == 60) ? "checked" : ""; ?>>
        <label for="gadi2">31 - 60</label><br>

        <input type="radio" id="gadi3" name="gadi" value="100" <?php echo ($gadi == 100) ? "checked" : ""; ?>>
        <label for="gadi3">61 - 100</label><br>
    </fieldset>
    <br>
    <fieldset>
        <legend>Transports:</legend>
        <label for="masina">Izvēlies mīļāko automašīnas marku:</label>
        <select id="masina" name="masina">
            <option value="">Izvēlies</option>
            <option value="kia" <?php echo ($masina == "kia") ? "selected" : ""; ?>>kia</option>
            <option value="bmw" <?php echo ($masina == "bmw") ? "selected" : ""; ?>>BMW</option>
            <option value="skoda" <?php echo ($masina == "skoda") ? "selected" : ""; ?>>Skoda</option>
            <option value="audi" <?php echo ($masina == "audi") ? "selected" : ""; ?>>Audi</option>
        </select>
        <br><br>

        <label>Ar ko Jūs pārvietojaties:</label><br>
        <input type="checkbox" id="transports1" name="lidmasina" value="1" <?php echo ($lidmasina == 1) ? "checked" : ""; ?>>
        <label for="transports1"> Ar lidmasinu</label><br>

        <input type="checkbox" id="transports2" name="transports" value="1" <?php echo ($transports == 1) ? "checked" : ""; ?>>
        <label for="transports2"> Ar automašīnu</label><br>

        <input type="checkbox" id="transports3" name="helekopters" value="1" <?php echo ($helekopters == 1) ? "checked" : ""; ?>>
        <label for="transports3"> Ar helikoptoru</label><br><br>
    </fieldset>
    <br><br>

    <input type="submit" value="Saglabāt">
    <input type="reset" value="Notīrīt">
</form>

<div id="resultMsg"></div>

<?php include "izvade.php"; ?>

<script>
function validateForm() {
    let valid = true;
    const vards = document.getElementById('vards');
    const uzvards = document.getElementById('uzvards');
    const dzimsanas_datums = document.getElementById('dzimsanas_datums');
    const masina = document.getElementById('masina');
    
    // Сброс подсветки
    [vards, uzvards, dzimsanas_datums, masina].forEach(el => el.classList.remove('error'));
    
    // Проверка обязательных полей и длины >5
    if (!vards.value.trim() || vards.value.trim().length < 5) {
        vards.classList.add('error');
        valid = false;
    }
    if (!uzvards.value.trim() || uzvards.value.trim().length < 5) {
        uzvards.classList.add('error');
        valid = false;
    }
    if (!masina.value) {
        masina.classList.add('error');
        valid = false;
    }

    // Проверка даты
    const today = new Date();
    const minDate = new Date();
    minDate.setFullYear(today.getFullYear() - 100); // не меньше 100 лет
    const maxDate = today; // не больше сегодня
    const inputDate = new Date(dzimsanas_datums.value);
    
    if (isNaN(inputDate.getTime()) || inputDate < minDate || inputDate > maxDate) {
        dzimsanas_datums.classList.add('error');
        valid = false;
    }
    
    if (!valid) {
        document.getElementById('resultMsg').innerText = "Lūdzu, aizpildiet laukus pareizi!";
    } else {
        document.getElementById('resultMsg').innerText = "";
    }

    return valid; // false блокирует submit
}
</script>

</body>
</html>
