/*autors: Veronika Osko
    veidoja:31.03.2025.
    izmantoja online kompilatoru programiz.com */
    
using System;

class Program {
  static void Main() {
    // Ievadām vārdu un uzvārdu
    string vards = "Veronika";
    string uzvards = "Osko";

    // Ģenerējam 2D masīvu ar nejaušiem skaitļiem
    int[, ] dati = TabulasDati(vards, uzvards);

    // Izvadām tabulas galveni
    TabulaGalva(vards);

    // Izvadām sākotnējo tabulu
    Tabula(dati);

    Console.WriteLine("\nPec tabulas mainas:\n");

    // Apmainām rindas ar kolonnām (transponējam tabulu)
    int[, ] jauniDati = TabulasMaina(dati);

    // Izvadām tabulas galveni pēc maiņas
    TabulaGalva(vards);

    // Izvadām transponēto tabulu
    Tabula(jauniDati);
  }

  // Metode, kas zīmē līniju tabulai
  static void TabulasLinija(int svitras, int reizes) {
    for (int i = 0; i < reizes; i++) {
      Console.Write("*");
      for (int j = 0; j < svitras; j++)
        Console.Write("-");
    }
    Console.WriteLine("*");
  }

  // Metode, kas izvada tabulas rindu ar datiem un statistiku
  static void TabulasRinda(int[] dati, int max, int min, int sum) {
    Console.Write("| ");
    foreach(int skaitlis in dati) {
      Console.Write(skaitlis + " | ");
    }
    Console.Write($"max | {max} | min | {min} | sum | {sum} |");
    Console.WriteLine();
  }

  // Funkcija, kas ģenerē 2D masīvu ar nejaušiem skaitļiem
  static int[, ] TabulasDati(string vards, string uzvards) {
    Random rand = new Random();
    int rindas = vards.Length;
    int kolonnas = uzvards.Length;
    int[, ] dati = new int[rindas, kolonnas];

    for (int i = 0; i < rindas; i++) {
      for (int j = 0; j < kolonnas; j++) {
        dati[i, j] = rand.Next(vards.Length, vards.Length + uzvards.Length + 1);
      }
    }
    return dati;
  }

  // Metode, kas izvada tabulas galveni
  static void TabulaGalva(string vards) {
    Console.WriteLine($"\nTabula: {vards}");
    TabulasLinija(3, 5);
    Console.WriteLine("| Dati | max | min | sum |");
    TabulasLinija(3, 5);
  }

  // Metode, kas izvada visu tabulu
  static void Tabula(int[, ] dati) {
    for (int i = 0; i < dati.GetLength(0); i++) {
      int[] rinda = new int[dati.GetLength(1)];
      for (int j = 0; j < dati.GetLength(1); j++) {
        rinda[j] = dati[i, j];
      }
      int max = Max(rinda);
      int min = Min(rinda);
      int sum = Sum(rinda);
      TabulasRinda(rinda, max, min, sum);
    }
    TabulasLinija(3, 5);
  }

  // Funkcija, kas apmaina rindas ar kolonnām (transponē matricu)
  static int[, ] TabulasMaina(int[, ] dati) {
    int jaunasRindas = dati.GetLength(1);
    int jaunasKolonnas = dati.GetLength(0);
    int[, ] jauniDati = new int[jaunasRindas, jaunasKolonnas];

    for (int i = 0; i < jaunasRindas; i++) {
      for (int j = 0; j < jaunasKolonnas; j++) {
        jauniDati[i, j] = dati[j, i];
      }
    }
    return jauniDati;
  }

  // Palīgfunkcijas, kas aprēķina maksimālo, minimālo un summu
  static int Max(int[] masivs) {
    int max = masivs[0];
    foreach(int skaitlis in masivs) {
      if (skaitlis > max) max = skaitlis;
    }
    return max;
  }

  static int Min(int[] masivs) {
    int min = masivs[0];
    foreach(int skaitlis in masivs) {
      if (skaitlis < min) min = skaitlis;
    }
    return min;
  }

  static int Sum(int[] masivs) {
    int sum = 0;
    foreach(int skaitlis in masivs) {
      sum += skaitlis;
    }
    return sum;
  }
}