 /*autors: Veronika Osko
          110.grupa
          Jelgavas tehnikums
          11.03.2025.
          veidoja izmantojot https://www.programiz.com/csharp-programming/online-compiler/ */

using System;
using System.Collections.Generic; // Nepieciešams List<string>
using System.Linq; // Nepieciešams Enumerable.Range un .ToArray()

public class ParoluGenerator
{
    public static void Main(string[] args)
    {
        // Uzsāk programmu.
        Console.WriteLine("Uzdevums - robainie masvi.");

        // Ievades mainīgie.
        int paroluSkaits;
        int minGarums;
        bool lieliBurti;
        bool cipariSimboli;

        // Ievada parolu skaitu.
        Console.Write("Ievadiet parolu SKAITU, kas lielāks par 4: ");
        while (!int.TryParse(Console.ReadLine(), out paroluSkaits) || paroluSkaits <= 4)
        {
            // Pārbauda ievadi.
            Console.Write("Nepareiza ievade. Ievadiet skaitli, kas lielaks par 4: ");
        }

        // Ievada minimālo garumu.
        Console.Write("Ievadiet GARAKO paroles simbolu skaitu, kas lielāks par 9: ");
        while (!int.TryParse(Console.ReadLine(), out minGarums) || minGarums <= 9)
        {
            // Pārbauda ievadi.
            Console.Write("Nepareiza ievade. Ievadiet skaitli, kas lielāks par 9: ");
        }

        // Jautā par lielajiem burtiem.
        Console.Write("Vajag Lielos burtus simboliem (y/n): ");
        lieliBurti = Console.ReadLine().ToLower() == "y";

        // Jautā par cipariem un simboliem.
        Console.Write("Vajag ciparus un simbolus simboliem (y/n): ");
        cipariSimboli = Console.ReadLine().ToLower() == "y";

        // Izveido sarakstu parolēm.
        List<string> paroles = new List<string>();
        Random random = new Random(); // Izveido Random objektu.

        // Ģenerē paroles.
        for (int i = 0; i < paroluSkaits; i++)
        {
            // Ģenerē vienu paroli.
            paroles.Add(GeneretParoli(minGarums, lieliBurti, cipariSimboli, random));
        }

        // Izvada ģenerētās paroles.
        Console.WriteLine("\ngeneretas paroles:");
        foreach (string parole in paroles)
        {
            // Izvada katru paroli.
            Console.WriteLine($"Parole: {parole}");
        }
    }

    // Metode paroles ģenerēšanai.
    private static string GeneretParoli(int garums, bool iekļautLielosBurtus, bool iekļautCiparusSimbolus, Random random)
    {
        // Definē simbolu kopas.
        string mazieBurti = "abcdefghijklmnopqrstuvwxyz";
        string lielieBurti = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        string cipari = "0123456789";
        string simboli = "!@#$%^&*()_-+=<>?";

        // Izveido pieejamo simbolu stringu.
        string visiSimboli = mazieBurti;
        if (iekļautLielosBurtus)
        {
            // Pievieno lielos burtus.
            visiSimboli += lielieBurti;
        }
        if (iekļautCiparusSimbolus)
        {
            // Pievieno ciparus un simbolus.
            visiSimboli += cipari + simboli;
        }

        // Pārbauda, vai ir pietiekami daudz simbolu.
        if (visiSimboli.Length == 0)
        {
            // Kļūdas ziņojums.
            return "Kluda: Nav pieejamu simbolu paroles generesanai.";
        }

        // Izveido rakstzīmju masīvu.
        char[] paroleArray = new char[garums];
        for (int i = 0; i < garums; i++)
        {
            // Izvēlas nejaušu simbolu.
            paroleArray[i] = visiSimboli[random.Next(visiSimboli.Length)];
        }

        // Atgriež paroli.
        return new string(paroleArray);
    }
}