 /*autors: Veronika Osko
          110.grupa
          Jelgavas tehnikums
          11.03.2025.
          veidoja izmantojot https://www.programiz.com/csharp-programming/online-compiler/ */

using System;
using System.Linq; // Enumerable.Repeat izmantošanai
using System.Text;
using System.Collections.Generic; // List<int> izmantošanai

public class TableGenerator
{
    // Palīgfunkcija: maina burtu lielumu (katrs otrais Lielais)
    public static string ApplyAlternatingCase(string input)
    {
        if (string.IsNullOrEmpty(input)) return input;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.Length; i++)
        {
            if (i % 2 == 0) // Pāra indekss (0, 2, 4...) -> Lielais burts
            {
                sb.Append(char.ToUpper(input[i]));
            }
            else // Nepāra indekss (1, 3, 5...) -> Mazais burts
            {
                sb.Append(char.ToLower(input[i]));
            }
        }
        return sb.ToString();
    }

    // Palīgfunkcija: centrē tekstu tabulas šūnā
    public static string CenterStringForTable(string s, int width)
    {
        if (s.Length >= width)
        {
            return s; 
        }

        int totalPadding = width - s.Length;
        int leftPadding = totalPadding / 2;
        int rightPadding = totalPadding - leftPadding; 

        return new string(' ', leftPadding) + s + new string(' ', rightPadding);
    }

    // Palīgfunkcija: zīmē tabulas rāmja līniju
    public static void DrawTableLine(
        char verticalChar, 
        char horizontalChar, 
        char cornerChar, 
        bool includeStatsCols, 
        int headerColWidth, 
        int dataColWidth, 
        int statsColWidth, 
        int numDataCols)
    {
        Console.Write(cornerChar);
        Console.Write(new string(horizontalChar, headerColWidth)); // Pirmā kolonna (X / uzvārds)
        Console.Write(cornerChar);
        for (int i = 0; i < numDataCols; i++)
        {
            Console.Write(new string(horizontalChar, dataColWidth)); // Datu kolonnas
            Console.Write(cornerChar);
        }
        if (includeStatsCols) // Ja iekļauj sum, min, max kolonnas
        {
            Console.Write(new string(horizontalChar, statsColWidth)); // sum
            Console.Write(cornerChar);
            Console.Write(new string(horizontalChar, statsColWidth)); // min
            Console.Write(cornerChar);
            Console.Write(new string(horizontalChar, statsColWidth)); // max
            Console.Write(cornerChar);
        }
        Console.WriteLine();
    }

    // Programmas sākuma punkts
    public static void Main(string[] args)
    {
        GenerateTables();
    }

    public static void GenerateTables()
    {
        // 1. Ievada vārdu
        Console.Write("Ievadi vardu: ");
        string vards = Console.ReadLine();

        // 2. Ievada uzvārdu
        Console.Write("Ievadi uzvardu: ");
        string uzvards = Console.ReadLine();

        Console.WriteLine(); 

        // 3. Izvada vārdu un tā garumu (katrs otrais Lielais)
        string alternatingCaseVards = ApplyAlternatingCase(vards);
        Console.WriteLine($"Mans vards ir {alternatingCaseVards} un taja ir {vards.Length} simboli");

        Console.WriteLine(); 

        // Tabulas kolonnu platumi
        int headerColWidth = 3; 
        int dataColWidth = 5;  
        int statsColWidth = 7; 

        // Datu masīva izmēri (Uzvārds rindās, Vārds kolonnās)
        int numRowsData = uzvards.Length;
        int numColsData = vards.Length;

        Random random = new Random();
        int minRandom = vards.Length;
        int maxRandom = vards.Length + uzvards.Length;

        // Izveido 2D masīvu un aizpilda ar gadījuma skaitļiem
        int[,] dataArray = new int[numRowsData, numColsData];
        for (int r = 0; r < numRowsData; r++)
        {
            for (int c = 0; c < numColsData; c++)
            {
                dataArray[r, c] = random.Next(minRandom, maxRandom + 1);
            }
        }

        // Aprēķina kolonnu summas, min, max
        int[] colSums = new int[numColsData];
        int[] colMins = Enumerable.Repeat(int.MaxValue, numColsData).ToArray();
        int[] colMaxs = Enumerable.Repeat(int.MinValue, numColsData).ToArray();

        for (int c = 0; c < numColsData; c++)
        {
            for (int r = 0; r < numRowsData; r++)
            {
                int val = dataArray[r, c];
                colSums[c] += val;
                if (val < colMins[c]) colMins[c] = val;
                if (val > colMaxs[c]) colMaxs[c] = val;
            }
        }
        
        // --- Zīmējam pirmo tabulu ---
        // Augšējā mala
        DrawTableLine('+', '-', '+', true, headerColWidth, dataColWidth, statsColWidth, numColsData); 

        // Pirmā rinda (X un Vārda burti)
        Console.Write($"| {CenterStringForTable("X", headerColWidth)}");
        for (int i = 0; i < vards.Length; i++)
        {
            Console.Write($"| {CenterStringForTable(char.ToUpper(vards[i]).ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("sum", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("min", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("max", statsColWidth)}");
        Console.WriteLine("|");

        // Līnija pēc pirmās rindas
        DrawTableLine('+', '-', '+', true, headerColWidth, dataColWidth, statsColWidth, numColsData); 

        // Datu rindas (Uzvārda burti no beigām un gadījuma skaitļi)
        for (int r = 0; r < numRowsData; r++)
        {
            char currentUzvardsChar = uzvards[numRowsData - 1 - r]; // Uzvārds no beigām
            string displayUzvardsChar = (r % 2 == 0) ? char.ToUpper(currentUzvardsChar).ToString() : char.ToLower(currentUzvardsChar).ToString();
            Console.Write($"| {CenterStringForTable(displayUzvardsChar, headerColWidth)}");

            int currentRowSum = 0;
            int currentRowMax = int.MinValue;
            int currentRowMin = int.MaxValue;

            for (int c = 0; c < numColsData; c++)
            {
                int val = dataArray[r, c];
                Console.Write($"| {CenterStringForTable(val.ToString(), dataColWidth)}");
                currentRowSum += val;
                if (val > currentRowMax) currentRowMax = val;
                if (val < currentRowMin) currentRowMin = val;
            }

            // Rindas aprēķini
            Console.Write($"| {CenterStringForTable(currentRowSum.ToString(), statsColWidth)}");
            Console.Write($"| {CenterStringForTable(currentRowMin.ToString(), statsColWidth)}");
            Console.Write($"| {CenterStringForTable(currentRowMax.ToString(), statsColWidth)}");
            Console.WriteLine("|");

            // Līnija pēc datu rindas
            DrawTableLine('+', '-', '+', true, headerColWidth, dataColWidth, statsColWidth, numColsData);
        }

        // --- SUM / MIN / MAX rindas kolonnām ---
        // Summu rinda
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, numColsData); 
        Console.Write($"| {CenterStringForTable("sum", headerColWidth)}");
        for (int c = 0; c < numColsData; c++)
        {
            Console.Write($"| {CenterStringForTable(colSums[c].ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.WriteLine("|");
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, numColsData); 

        // Min rinda
        Console.Write($"| {CenterStringForTable("min", headerColWidth)}");
        for (int c = 0; c < numColsData; c++)
        {
            Console.Write($"| {CenterStringForTable(colMins[c].ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.WriteLine("|");
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, numColsData); 

        // Max rinda
        Console.Write($"| {CenterStringForTable("max", headerColWidth)}");
        for (int c = 0; c < numColsData; c++)
        {
            Console.Write($"| {CenterStringForTable(colMaxs[c].ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.WriteLine("|");
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, numColsData); 

        Console.WriteLine("\n--- Transponētā tabula ---");

        // Izveido transponēto masīvu (kolonnas un rindas mainītas vietām)
        int[,] transposedDataArray = new int[numColsData, numRowsData]; 

        for (int r = 0; r < numRowsData; r++) 
        {
            for (int c = 0; c < numColsData; c++) 
            {
                transposedDataArray[c, r] = dataArray[r, c]; 
            }
        }

        // Transponētās tabulas vārds/uzvārds un izmēri
        string newVardsForTransposedTable = uzvards; // Tagad kolonnu galvene ir oriģinālais uzvārds
        string newUzvardsForTransposedTable = vards; // Tagad rindu galvene ir oriģinālais vārds
        
        int currentNumRowsTransposed = newUzvardsForTransposedTable.Length; 
        int currentNumColsTransposed = newVardsForTransposedTable.Length;   

        // Aprēķina transponētās tabulas kolonnu summas, min, max
        int[] colSumsTransposed = new int[currentNumColsTransposed];
        int[] colMinsTransposed = Enumerable.Repeat(int.MaxValue, currentNumColsTransposed).ToArray();
        int[] colMaxsTransposed = Enumerable.Repeat(int.MinValue, currentNumColsTransposed).ToArray();

        for (int c = 0; c < currentNumColsTransposed; c++)
        {
            for (int r = 0; r < currentNumRowsTransposed; r++)
            {
                int val = transposedDataArray[r, c]; 
                colSumsTransposed[c] += val;
                if (val < colMinsTransposed[c]) colMinsTransposed[c] = val;
                if (val > colMaxsTransposed[c]) colMaxsTransposed[c] = val;
            }
        }

        // --- Zīmējam transponēto tabulu ---
        // Augšējā mala
        DrawTableLine('+', '-', '+', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed);

        // Pirmā rinda (X un oriģinālā uzvārda burti)
        Console.Write($"| {CenterStringForTable("X", headerColWidth)}");
        for (int i = 0; i < currentNumColsTransposed; i++) 
        {
            char currentTransposedHeaderChar = newVardsForTransposedTable[i]; 
            string displayChar = (i % 2 == 0) ? char.ToUpper(currentTransposedHeaderChar).ToString() : char.ToLower(currentTransposedHeaderChar).ToString();
            Console.Write($"| {CenterStringForTable(displayChar, dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("sum", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("min", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("max", statsColWidth)}");
        Console.WriteLine("|");

        // Līnija pēc pirmās rindas
        DrawTableLine('+', '-', '+', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed);

        // Datu rindas (oriģinālā vārda burti no beigām un transponētie skaitļi)
        for (int r = 0; r < currentNumRowsTransposed; r++) 
        {
            char currentTransposedRowChar = newUzvardsForTransposedTable[currentNumRowsTransposed - 1 - r]; 
            string displayChar = (r % 2 == 0) ? char.ToUpper(currentTransposedRowChar).ToString() : char.ToLower(currentTransposedRowChar).ToString();
            Console.Write($"| {CenterStringForTable(displayChar, headerColWidth)}");

            int currentRowSum = 0;
            int currentRowMax = int.MinValue;
            int currentRowMin = int.MaxValue;

            for (int c = 0; c < currentNumColsTransposed; c++) 
            {
                int val = transposedDataArray[r, c]; 
                Console.Write($"| {CenterStringForTable(val.ToString(), dataColWidth)}");
                currentRowSum += val;
                if (val > currentRowMax) currentRowMax = val;
                if (val < currentRowMin) currentRowMin = val;
            }

            // Rindas aprēķini
            Console.Write($"| {CenterStringForTable(currentRowSum.ToString(), statsColWidth)}");
            Console.Write($"| {CenterStringForTable(currentRowMin.ToString(), statsColWidth)}");
            Console.Write($"| {CenterStringForTable(currentRowMax.ToString(), statsColWidth)}");
            Console.WriteLine("|");

            // Līnija pēc datu rindas
            DrawTableLine('+', '-', '+', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed);
        }

        // --- SUM / MIN / MAX rindas kolonnām transponētajā tabulā ---
        // Summu rinda
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed); 
        Console.Write($"| {CenterStringForTable("sum", headerColWidth)}");
        for (int c = 0; c < currentNumColsTransposed; c++)
        {
            Console.Write($"| {CenterStringForTable(colSumsTransposed[c].ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.WriteLine("|");
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed); 

        // Min rinda
        Console.Write($"| {CenterStringForTable("min", headerColWidth)}");
        for (int c = 0; c < currentNumColsTransposed; c++)
        {
            Console.Write($"| {CenterStringForTable(colMinsTransposed[c].ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.WriteLine("|");
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed); 

        // Max rinda
        Console.Write($"| {CenterStringForTable("max", headerColWidth)}");
        for (int c = 0; c < currentNumColsTransposed; c++)
        {
            Console.Write($"| {CenterStringForTable(colMaxsTransposed[c].ToString(), dataColWidth)}");
        }
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.Write($"| {CenterStringForTable("*", statsColWidth)}");
        Console.WriteLine("|");
        DrawTableLine('*', '=', '*', true, headerColWidth, dataColWidth, statsColWidth, currentNumColsTransposed); 
    }
}