/*autors: Veronika Osko
  datums: 09.05.2025.
  Jelgavas tehnikums
  110.grupa*/

using System;  // Ievadām nepieciešamo bibliotēku, kas satur pamata funkcijas, piemēram, Console.
using System.Collections.Generic;  // Ievadām kolekciju funkcionalitāti, lai izmantotu Listu.
using System.IO;  // Ievadām I/O funkcionalitāti, lai varētu strādāt ar failiem, ja nepieciešams.

class FileSystemObject  // Abstrakta klase, kas pārstāv jebkuru failu sistēmas objektu, gan mapes, gan datnes.
{
    public string Name { get; set; }  // Objekta nosaukums.
    public Folder Parent { get; set; }  // Vecāks objekts, kas var būt mape, kas satur šo objektu.

    public virtual void Show() { }  // Virtuālā metode, kas tiek pārmantota, lai parādītu objektu saturu (mapēm un datnēm).
}

class Folder : FileSystemObject  // Mape, kas ir FileSystemObject apakšklase.
{
    public List<FileSystemObject> Children = new List<FileSystemObject>();  // Saraksts, kas satur mapes bērnus (mājas vai datnes).

    public override void Show()  // Pārmantojam `Show()` metodi, lai parādītu mapes bērnus.
    {
        foreach (var child in Children)  // Izstaigājam visus bērnus, kas ir mapē.
        {
            // Ja bērns ir mape, izvadām to ar [] (pārbaudām ar `is Folder`).
            // Ja bērns ir datne, izvadām to ar ~[] (pārbaudām ar `is File`).
            Console.WriteLine(child is Folder ? $"/[{child.Name}]" : $"/~[{child.Name}]~");
        }
    }

    public void AddChild(FileSystemObject child)  // Metode bērnu pievienošanai.
    {
        // Pārbaudām, vai bērns jau eksistē, lai izvairītos no dubultiem nosaukumiem.
        if (!Children.Exists(c => c.Name == child.Name)) 
            Children.Add(child);  // Ja tāda nav, pievienojam bērnu.
    }

    public void RemoveChild(string name)  // Metode bērna dzēšanai pēc nosaukuma.
    {
        var child = Children.Find(c => c.Name == name);  // Meklējam bērnu ar konkrētu nosaukumu.
        if (child != null)  // Ja bērns ir atrasts, dzēšam to.
            Children.Remove(child);
    }
}

class File : FileSystemObject  // Datnes klase, kas arī ir `FileSystemObject` apakšklase.
{
    public void Edit()  // Metode faila rediģēšanai (šobrīd tikai izdrukā ziņojumu).
    {
        Console.WriteLine($"Editing file {Name}.txt");  // Izdrukā ziņojumu par faila rediģēšanu.
    }
}

class FileSystem  // Failu sistēmas galvenā klase, kas simulē darbības ar failiem un mapēm.
{
    static Folder root = new Folder { Name = "C:" };  // Sākotnējā mape, kas atbilst c: diskam.
    static Folder current = root;  // Pašreizējā aktīvā mape, sākot ar sakni.

    static void Main()  // Galvenā programma, kas darbojas kā komandrindas interfeiss.
    {
        while (true)  // Bezgalīga cilpa, kas pieļauj lietotāja ievadi un izpilda komandas.
        {
            Console.Write($"{current.Name}/> ");  // Parāda pašreizējo atrašanās vietu uz ekrāna.
            string command = Console.ReadLine().Trim();  // Lasām komandu no lietotāja.
            var args = command.Split(' ', StringSplitOptions.RemoveEmptyEntries);  // Ievadi sadalām pa argumentiem.

            if (args.Length == 0) continue;  // Ja ievade ir tukša, turpinām nākamo iterāciju.

            switch (args[0].ToLower())  // Pārbaudām pirmo komandu argumentu, kas norāda darbību.
            {
                case "mkdir":  // Ja komanda ir "mkdir" — izveidot mapi.
                    if (args.Length > 1)  // Ja ievadīti ir papildu argumenti.
                        current.AddChild(new Folder { Name = args[1], Parent = current });  // Pievienojam jaunu mapi.
                    break;

                case "create":  // Ja komanda ir "create" — izveidot datni.
                    if (args.Length > 1)  // Ja ievadīti ir papildu argumenti.
                        current.AddChild(new File { Name = args[1], Parent = current });  // Pievienojam jaunu datni.
                    break;

                case "dir":  // Ja komanda ir "dir" — parādīt mapes bērnus.
                    current.Show();  // Izsaucam `Show()` metodi, kas parāda bērnus.
                    break;

                case "cd":  // Ja komanda ir "cd" — mainīt aktuālo mapi.
                    if (args[1] == ".." && current.Parent != null)  // Ja args[1] ir "..", ejam atpakaļ.
                        current = current.Parent;  // Pārvietojamies uz vecāku mapi.
                    else  // Pretējā gadījumā, pārvietojamies uz bērnu mapi.
                        current = current.Children.Find(c => c.Name == args[1]) as Folder;  
                    break;

                case "rm":  // Ja komanda ir "rm" — dzēst bērnu (mapi vai datni).
                    current.RemoveChild(args[1]);  // Meklējam bērnu pēc nosaukuma un dzēšam to.
                    break;

                case "edit":  // Ja komanda ir "edit" — rediģēt datni.
                    var file = current.Children.Find(c => c.Name == args[1]) as File;  // Atrodam datni.
                    file?.Edit();  // Ja datne atrasta, izsaucam tās `Edit()` metodi.
                    break;

                case "exit":  // Ja komanda ir "exit" — iziet no programmas.
                    return;  // Aizver galveno metodi, kas izbeidz programmu.
            }
        }
    }
}