 /*autors: Veronika Osko
          110.grupa
          Jelgavas tehnikums
          04.03.2025.
          veidoja izmantojot https://www.programiz.com/csharp-programming/online-compiler/ */

using System;
using System.Linq;
using System.Text;
using System.Collections.Generic; // Nodrošina darbu ar sarakstiem (List<T>)

public class TableGenerator
{
    public static void Main(string[] args)
    {
        // Palaiž tabulas ģenerēšanas funkciju
        GenerateTable();
    }

    public static void GenerateTable()
    {
        // --- PERSONISKIE DATI ---

        // Izveido mainīgo "vards", kur tiek saglabāts lietotāja vārds
        string vards = "Veronika"; // Šeit vari ierakstīt jebkuru vārdu

        // Izveido mainīgo "uzvards", kur tiek saglabāts lietotāja uzvārds
        string uzvards = "Osko"; // Šeit ieraksti savu uzvārdu

        // Formatē vārdu: pirmais burts ar lielo, pārējie kā ir
        string capitalizedVards = char.ToUpper(vards[0]) + vards.Substring(1);

        // Izvada formatētu vārdu un tā simbolu skaitu
        Console.WriteLine($"Mans vards ir {capitalizedVards} un taja ir {vards.Length} simboli");

        // Formatē uzvārdu: pirmais burts ar lielo
        string capitalizedUzvards = char.ToUpper(uzvards[0]) + uzvards.Substring(1);

        // Izvada formatētu uzvārdu un tā garumu
        Console.WriteLine($"Mans uzvards ir {capitalizedUzvards} un taja ir {uzvards.Length} simboli");

        Console.WriteLine(); // Pievieno tukšu rindu pirms tabulas

        // --- TABULAS STRUKTŪRAS DEFINĒŠANA ---

        // Kolonnu platumi: nosaka cik daudz vietas atvēlēt katrā kolonnā
        int xColWidth = 3;        // Platums kolonnai, kurā būs uzvārda burti
        int charColWidth = 3;     // Platums katram vārda burtam (katrai kolonnai)
        int statsColWidth = 6;    // Platums statistikām: max, min, vid, sum

        // Aprēķina kopējo kolonnu skaitu (vārda burti + 4 statistikas kolonnas)
        int numCols = vards.Length + 4;

        // Rindu skaits = uzvārda garums (tik cik burtu uzvārdā) + 1 virsrinda
        int numRows = uzvards.Length + 1;

        // Iniciē gadījuma skaitļu ģeneratoru
        Random random = new Random();

        // Definē iespējamo skaitļu robežas (atkarīgas no vārda un uzvārda garuma)
        int minRandom = vards.Length;
        int maxRandom = vards.Length + uzvards.Length;

        // Izveido 2D sarakstu (rindas un kolonnas), kur glabāsies nejaušie skaitļi
        List<List<int>> tableData = new List<List<int>>();

        // Aizpilda šo tabulu ar nejaušiem skaitļiem katrai uzvārda burtu rindai
        for (int r = 0; r < uzvards.Length; r++)
        {
            List<int> rowData = new List<int>();

            for (int c = 0; c < vards.Length; c++)
            {
                // Ģenerē skaitli starp min un max (ieskaitot)
                rowData.Add(random.Next(minRandom, maxRandom + 1));
            }

            // Pievieno rindu sarakstam
            tableData.Add(rowData);
        }

        // --- TABULAS ZĪMĒŠANA ---

        // Zīmē tabulas augšējo malu
        Console.Write("+");
        Console.Write(new string('-', xColWidth));
        for (int i = 0; i < vards.Length; i++)
        {
            Console.Write("+");
            Console.Write(new string('-', charColWidth));
        }

        // Zīmē augšējo malu statistikām
        Console.Write("+");
        Console.Write(new string('-', statsColWidth)); // max
        Console.Write("+");
        Console.Write(new string('-', statsColWidth)); // min
        Console.Write("+");
        Console.Write(new string('-', statsColWidth)); // vid
        Console.Write("+");
        Console.Write(new string('-', statsColWidth)); // sum
        Console.WriteLine("+");

        // Zīmē galveni: "X" + vārda burti + statistikas nosaukumi
        Console.Write($"| {("X").PadRight(xColWidth - 1)}");
        for (int i = 0; i < vards.Length; i++)
        {
            Console.Write($"| {char.ToUpper(vards[i]).ToString().PadRight(charColWidth - 1)}");
        }
        Console.Write($"| {("max").PadRight(statsColWidth - 1)}");
        Console.Write($"| {("min").PadRight(statsColWidth - 1)}");
        Console.Write($"| {("vid").PadRight(statsColWidth - 1)}");
        Console.Write($"| {("sum").PadRight(statsColWidth - 1)}");
        Console.WriteLine("|");

        // Zīmē līniju zem galvenes
        Console.Write("+");
        Console.Write(new string('-', xColWidth));
        for (int i = 0; i < vards.Length; i++)
        {
            Console.Write("+");
            Console.Write(new string('-', charColWidth));
        }
        Console.Write("+");
        Console.Write(new string('-', statsColWidth));
        Console.Write("+");
        Console.Write(new string('-', statsColWidth));
        Console.Write("+");
        Console.Write(new string('-', statsColWidth));
        Console.Write("+");
        Console.Write(new string('-', statsColWidth));
        Console.WriteLine("+");

        // --- Datu rindu zīmēšana ---
        for (int r = 0; r < uzvards.Length; r++)
        {
            // Izvada uzvārda burtu (mazie burti)
            Console.Write($"| {uzvards[r].ToString().PadRight(xColWidth - 1)}");

            int currentRowSum = 0;               // Summa visai rindai
            int currentRowMax = int.MinValue;    // Maksimālā vērtība rindā
            int currentRowMin = int.MaxValue;    // Minimālā vērtība rindā

            for (int c = 0; c < vards.Length; c++)
            {
                int val = tableData[r][c];
                Console.Write($"| {val.ToString().PadRight(charColWidth - 1)}");

                currentRowSum += val;
                if (val > currentRowMax) currentRowMax = val;
                if (val < currentRowMin) currentRowMin = val;
            }

            // Vidējā vērtība ar vienu zīmi aiz komata
            double currentRowAvg = (double)currentRowSum / vards.Length;

            // Izvada statistikas datus katras rindas beigās
            Console.Write($"| {currentRowMax.ToString().PadRight(statsColWidth - 1)}");
            Console.Write($"| {currentRowMin.ToString().PadRight(statsColWidth - 1)}");
            Console.Write($"| {currentRowAvg.ToString("F1").PadRight(statsColWidth - 1)}");
            Console.Write($"| {currentRowSum.ToString().PadRight(statsColWidth - 1)}");
            Console.WriteLine("|");

            // Zīmē līniju zem rindas
            Console.Write("+");
            Console.Write(new string('-', xColWidth));
            for (int i = 0; i < vards.Length; i++)
            {
                Console.Write("+");
                Console.Write(new string('-', charColWidth));
            }
            Console.Write("+");
            Console.Write(new string('-', statsColWidth));
            Console.Write("+");
            Console.Write(new string('-', statsColWidth));
            Console.Write("+");
            Console.Write(new string('-', statsColWidth));
            Console.Write("+");
            Console.Write(new string('-', statsColWidth));
            Console.WriteLine("+");
        }
    }
    
}
