 /*autors: Veronika Osko
          110.grupa
          Jelgavas tehnikums
          04.03.2025.
          veidoja izmantojot https://www.programiz.com/csharp-programming/online-compiler/ */

using System;
using System.Linq;
using System.Text;

public class TextManipulation
{
    public static void Main(string[] args)
    {
        ManipulateText();
    }

    public static void ManipulateText()
    {
        // Ievade no lietotāja
        Console.Write("Ievadi tekstu: ");
        string inputText = Console.ReadLine();

        // Apgriež vārdus teikumā
        string[] words = inputText.Split(' ', StringSplitOptions.RemoveEmptyEntries);
        Array.Reverse(words); // Apgriež vārdu secību
        string reversedWords = string.Join(" ", words); // Saliek atpakaļ teikumā

        // Pārveido pirmo burtu par lielo
        string capitalizedReversedWords = "";
        if (reversedWords.Length > 0)
            capitalizedReversedWords = char.ToUpper(reversedWords[0]) + reversedWords.Substring(1);
        
        Console.WriteLine($"Samainīti vardi: {capitalizedReversedWords}");

        // Apgriež visu tekstu simbolu līmenī
        char[] reversedFullTextArray = inputText.ToCharArray();
        Array.Reverse(reversedFullTextArray);
        string reversedFullText = new string(reversedFullTextArray);

        // Atjauno vārdus tekstā, apgriež katru vārdu atpakaļ
        string[] reversedWordsInReversedText = reversedFullText.Split(' ', StringSplitOptions.RemoveEmptyEntries);
        for (int i = 0; i < reversedWordsInReversedText.Length; i++)
        {
            char[] wordChars = reversedWordsInReversedText[i].ToCharArray();
            Array.Reverse(wordChars); // Atpakaļ uz pareizu burtu secību vārdā
            reversedWordsInReversedText[i] = new string(wordChars);
        }

        // Apvieno un padara pirmo burtu lielo
        string reversedReversedWordsCapitalized = string.Join(" ", reversedWordsInReversedText);
        if (reversedReversedWordsCapitalized.Length > 0)
            reversedReversedWordsCapitalized = char.ToUpper(reversedReversedWordsCapitalized[0]) + reversedReversedWordsCapitalized.Substring(1);

        Console.WriteLine($"Samainīti burti vardos: {reversedReversedWordsCapitalized}");

        // Sāk centrētu izvadi no teksta vidus
        int n = inputText.Length;
        int center1, center2;
        if (n % 2 == 0)
        {
            center1 = n / 2 - 1; // Kreisais centrs
            center2 = n / 2;     // Labais centrs
        }
        else
        {
            center1 = center2 = n / 2; // Viens centrs
        }

        // Izvada tekstu no centra, pievienojot simbolus abās pusēs
        for (int i = 0; i < (n + 1) / 2; i++)
        {
            int startIndex = Math.Max(0, center1 - i);
            int endIndex = Math.Min(n, center2 + i + 1);
            string sub = inputText.Substring(startIndex, endIndex - startIndex);
            Console.WriteLine(CenterString(sub, n));
        }

        // Dzēš burtus no vidus uz ārpusi
        StringBuilder currentTextSb = new StringBuilder(inputText);
        for (int i = 0; i < (n + 1) / 2; i++)
        {
            if (center1 - i >= 0)
                currentTextSb[center1 - i] = ' '; // Aizvieto ar tukšumu
            if (center2 + i < n)
                currentTextSb[center2 + i] = ' ';
            Console.WriteLine(CenterString(currentTextSb.ToString(), n));
        }

        // Parāda tekstu no beigām, katru reizi vairāk uz sākumu
        for (int i = 0; i < n; i++)
        {
            string sub = inputText.Substring(n - 1 - i);
            Console.WriteLine(RightAlignString(sub, n));
        }

        // Parāda tekstu no sākuma, katru reizi mazāk simbolu — trīsstūris
        for (int i = 0; i < n; i++)
        {
            string sub = inputText.Substring(0, n - i);
            Console.WriteLine(sub);
        }
    }

    // Centrē virkni noteiktā platumā
    public static string CenterString(string s, int width)
    {
        if (s.Length >= width) return s;
        int totalPadding = width - s.Length;
        int leftPadding = totalPadding / 2;
        int rightPadding = totalPadding - leftPadding;
        return new string(' ', leftPadding) + s + new string(' ', rightPadding);
    }

    // Izlīdzina virkni pa labi
    public static string RightAlignString(string s, int width)
    {
        if (s.Length >= width) return s;
        return new string(' ', width - s.Length) + s;
    }
}
