 /*autors: Veronika Osko
          110.grupa
          Jelgavas tehnikums
          04.03.2025.
          veidoja izmantojot https://www.programiz.com/csharp-programming/online-compiler/ */

using System;

public class Program
{
    public static void Main(string[] args)
    {
        // Vārds un uzvārds ar lielajiem burtiem
        string persona = "VERONIKA OSKO";

        // Sadalām vārdu un uzvārdu
        string[] nameParts = persona.Split(' ');

        // Formatē vārdu ar lielo pirmo burtu
        string firstName = ToTitleCase(nameParts[0]);
        Console.WriteLine($"Vārds: {firstName}");

        // Formatē uzvārdu
        string lastName = ToTitleCase(nameParts[1]);
        Console.WriteLine($"Uzvārds: {lastName}");

        // Pieprasa kolonu skaitu (>=5)
        int kolonuSkaits;
        while (true)
        {
            Console.Write("Ievadi kolonu skaitu, ne mazāk ka 5: ");
            string input = Console.ReadLine();

            // Pārbauda, vai ievade ir vesels skaitlis
            if (int.TryParse(input, out kolonuSkaits))
            {
                // Pārbauda, vai skaitlis nav mazāks par 5
                if (kolonuSkaits >= 5)
                {
                    break; // Izejam no cikla, ja viss korekti
                }
                else
                {
                    Console.WriteLine("Kļūda: Kolonu skaits nedrīkst būt mazāks par 5. Mēģiniet vēlreiz.");
                }
            }
            else
            {
                Console.WriteLine("Kļūda: Nederīga ievade. Lūdzu, ievadiet veselu skaitli.");
            }
        }

        // Izvada ievadīto kolonu skaitu
        Console.WriteLine($"Ievadi kolonu skaitu, ne mazāk ka 5: {kolonuSkaits}");
        
        // Ģenerē tabulu ar norādīto kolonnu skaitu
        GeneratePattern(kolonuSkaits);
    }

    // Padara pirmo burtu lielu, pārējos mazus
    private static string ToTitleCase(string s)
    {
        if (string.IsNullOrEmpty(s))
            return s;

        return char.ToUpper(s[0]) + s.Substring(1).ToLower();
    }

    // Ģenerē divdaļīgu rakstu (trijstūris + kāpnes)
    private static void GeneratePattern(int numColumns)
    {
        int cellWidth = 4; // Vienas šūnas platums

        // 1. daļa: Izlīdzināts pa labi, rindas ar 1..i skaitļiem
        for (int i = 1; i <= numColumns; i++)
        {
            // Tukšumi pirms rindas izlīdzināšanai
            string leadingSpaces = new string(' ', (numColumns - i) * cellWidth);

            // Augšējā līnija
            string rowTopBorder = leadingSpaces + "+";
            for (int k = 0; k < i; k++)
            {
                rowTopBorder += "---+";
            }
            Console.WriteLine(rowTopBorder);

            // Skaitļu rinda
            string numbersRow = leadingSpaces + "|";
            for (int j = 1; j <= i; j++)
            {
                numbersRow += $" {j} |";
            }
            Console.WriteLine(numbersRow);
        }

        // Apakšējā līnija 1. daļai
        string finalBottomBorderPart1 = "+";
        for (int k = 0; k < numColumns; k++)
        {
            finalBottomBorderPart1 += "---+";
        }
        Console.WriteLine(finalBottomBorderPart1);

        // 2. daļa: Izlīdzināta pa kreisi, 1..i rindas
        for (int i = 1; i <= numColumns; i++)
        {
            // Augšējā līnija
            string rowTopBorder = "+";
            for (int k = 0; k < i; k++)
            {
                rowTopBorder += "---+";
            }
            Console.WriteLine(rowTopBorder);

            // Skaitļu rinda
            string numbersRow = "|";
            for (int j = 1; j <= i; j++)
            {
                numbersRow += $" {j} |";
            }
            Console.WriteLine(numbersRow);
        }

        // Apakšējā līnija 2. daļai
        string finalBottomBorderPart2 = "+";
        for (int k = 0; k < numColumns; k++)
        {
            finalBottomBorderPart2 += "---+";
        }
        Console.WriteLine(finalBottomBorderPart2);
    }
}
