 /*autors: Veronika Osko
          110.grupa
          Jelgavas tehnikums
          04.03.2025.
          veidoja izmantojot https://www.programiz.com/csharp-programming/online-compiler/ */

using System;
using System.Text;

public class TableGenerator // Programmas klase
{
    public static void Main(string[] args) // Programmas sākumpunkts
    {
        string fullName = "VERONIKA OSKO"; // Vārds un uzvārds ar lielajiem burtiem

        // Formatē vārdu: pirmais burts liels, pārējie mazi
        string firstName = GetFormattedName(fullName.Split(' ')[0]);
        Console.WriteLine($"Mans vārds: {firstName}");

        // Formatē uzvārdu tāpat
        string lastName = GetFormattedName(fullName.Split(' ')[1]);
        Console.WriteLine($"Mana uzvārds: {lastName}");

        int minRows = 5; // Minimālais rindu skaits
        int minCols = 5; // Minimālais kolonnu skaits

        int numRows; // Lietotāja ievadītās rindas
        do
        {
            Console.Write($"Ievadi rindu skaitu, ne mazāk kā {minRows}: ");
        } while (!int.TryParse(Console.ReadLine(), out numRows) || numRows < minRows); // Atkārto, kamēr ievade ir korekta

        int numCols; // Lietotāja ievadītās kolonnas
        do
        {
            Console.Write($"Ievadi kolonu skaitu, ne mazāk kā {minCols}: ");
        } while (!int.TryParse(Console.ReadLine(), out numCols) || numCols < minCols); // Validācija

        Console.WriteLine(); // Tukša rinda vizuāliem nolūkiem

        GenerateAndPrintTable(numRows, numCols); // Izsauc funkciju tabulas ģenerēšanai
    }

    // Funkcija, kas formatē vārdu vai uzvārdu
    private static string GetFormattedName(string name)
    {
        if (string.IsNullOrEmpty(name))
            return string.Empty; // Ja tukšs, atgriež tukšu

        // Pirmais burts liels, pārējie mazi
        return char.ToUpper(name[0]) + name.Substring(1).ToLower();
    }

    // Funkcija tabulas zīmēšanai
    private static void GenerateAndPrintTable(int rows, int cols)
    {
        int contentWidthPerCell = 3; // Platums vienai šūnai (3 simboli)

        for (int i = 0; i < rows; i++) // Caur visām rindām
        {
            int currentNumCellsInRow; // Cik šūnas šajā rindā
            int currentStartNum;      // Ar kuru skaitli sākt rindu

            if (i < cols) // Trijstūra augošā daļa
            {
                currentNumCellsInRow = i + 1;
                currentStartNum = 1;
            }
            else // Taisnstūra daļa pēc trijstūra
            {
                currentNumCellsInRow = cols;
                currentStartNum = (i - cols) + 2; // Palielina sākuma skaitli katrā nākamajā rindā
            }

            // Izrēķina atstarpes pirms rindas (simetrijai)
            int leadingSpacesCount = (cols - currentNumCellsInRow) * (contentWidthPerCell + 1);
            Console.Write(new string(' ', leadingSpacesCount));

            // Zīmē augšējo robežu "+---+---+..."
            Console.Write("+");
            for (int j = 0; j < currentNumCellsInRow; j++)
            {
                Console.Write(new string('-', contentWidthPerCell) + "+");
            }
            Console.WriteLine();

            // Atstarpes vēlreiz saturam
            Console.Write(new string(' ', leadingSpacesCount));

            // Zīmē saturu "|  1|  2|..."
            Console.Write("|");
            for (int j = 0; j < currentNumCellsInRow; j++)
            {
                // Skaitļi rindā, izlīdzināti pa labi
                Console.Write(string.Format("{0," + contentWidthPerCell + "}|", currentStartNum + j));
            }
            Console.WriteLine();
        }

        // Nosaka, cik šūnas pēdējai apakšējai robežai
        int finalBorderCells = rows >= cols ? cols : rows;

        // Atstarpes pirms apakšējās līnijas
        int leadingSpacesForFinalBorder = (cols - finalBorderCells) * (contentWidthPerCell + 1);
        Console.Write(new string(' ', leadingSpacesForFinalBorder));

        // Apakšējā robeža "+---+---+..."
        Console.Write("+");
        for (int j = 0; j < finalBorderCells; j++)
        {
            Console.Write(new string('-', contentWidthPerCell) + "+");
        }
        Console.WriteLine();
    }
}
