namespace ConsoleApp1;

class Program {
    private static readonly Random randoms = new();

    static void Main() {
        var vards = "Rihards";
        var uzvards = "Lapiņš";
        
        int[,] panemaRandoma = PanemtRandoma(vards.Length, vards.Length, 1, 23);
        
        TabulaGalva(vards);

        Tabula(panemaRandoma);
        Console.WriteLine();
        Console.WriteLine();
        TabulaGalva(uzvards);

        Tabula(TabulasMaina(panemaRandoma));
    }

    private static void TabulasLinija(int svitras, int reizes) {
        for (var i = 0; i < reizes; i++) {
            Console.Write("*");
            for (var j = 0; j < svitras; j++) {
                Console.Write("-");
            }
        }

        Console.Write("*");
    }

    private static void TabulasRinda(int[] rindasDati, int max, int min, int sum) {
        for (var j = 0; j < rindasDati.Length; j++) {
            Console.Write($"| {rindasDati[j]} ");
        }

        Console.WriteLine($"| {max} | {min} | {sum} |");
    }

    private static int[,] TabulasDati(string vards, string uzvards) {
        var minGarums = vards.Length;
        var maxGarums = vards.Length + uzvards.Length;

        var rindas = maxGarums;
        var kolonnas = minGarums;

        int[,] dati = new int[rindas, kolonnas];

        for (var i = 0; i < rindas; i++) {
            for (var j = 0; j < kolonnas; j++) {
                dati[i, j] = randoms.Next(minGarums, maxGarums + 1);
            }
        }

        return dati;
    }

    private static void TabulaGalva(string vards) {
        TabulasLinija(4, vards.Length + 2);
        Console.WriteLine();
        Console.Write("|");

        for (var i = 0; i < vards.Length; i++) {
            Console.Write(" " + vards[i] + " |");
        }

        Console.Write(" min | max | sum |");
        Console.WriteLine();
        TabulasLinija(4, vards.Length + 2);
        Console.WriteLine();
    }

    private static void Tabula(int[,] dati) {
        for (var i = 0; i < dati.GetLength(0); i++) {
            var min = 2147483647;
            var max = -2147483648;
            var sum = 0;

            for (var j = 0; j < dati.GetLength(1); j++) {
                var k = dati[i, j];
                sum += k;

                if (k > max)
                    max = k;

                if (k < min)
                    min = k;
            }

            if (i != 0) {
                Console.WriteLine();
            }

            TabulasRinda(Dati(dati, i), max, min, sum);
            TabulasLinija(4, dati.GetLength(1) + 2);
        }
    }

    private static int[] Dati(int[,] dati, int j) {
        var kolonnas = dati.GetLength(1);
        int[] rindas = new int[kolonnas];

        for (var i = 0; i < kolonnas; i++) {
            rindas[i] = dati[j, i];
        }

        return rindas;
    }

    private static int[,] PanemtRandoma(int rindas, int kolonnas, int min, int max) {
        int[,] masivs = new int[rindas, kolonnas];

        for (var i = 0; i < rindas; i++) {
            for (var j = 0; j < kolonnas; j++) {
                masivs[i, j] = randoms.Next(min, max + 1);
            }
        }

        return masivs;
    }

    private static int[,] TabulasMaina(int[,] dati) {
        var rindas = dati.GetLength(0);
        var kolonnas = dati.GetLength(1);

        int[,] jauniDati = new int[kolonnas, rindas];

        for (var i = 0; i < rindas; i++) {
            for (var j = 0; j < kolonnas; j++) {
                jauniDati[j, i] = dati[i, j];
            }
        }

        return jauniDati;
    }
}