﻿namespace Bankas_parvaldibas_sistema;

class BankasKonts {
    // no: https://sentry.io/answers/generate-a-random-integer-in-csharp/
    private static readonly Random rng = new();

    private readonly string ipasnieks;
    private readonly string numurs = rng.Next(1, 1000000).ToString();
    private decimal atlikums;

    public BankasKonts(string ipasnieks) {
        this.ipasnieks = ipasnieks;
        Console.WriteLine($"Konts izveidots. Konta numurs: {numurs}");
    }

    // Nogulda naudu kontā
    public void Noguldit(decimal summa) {
        if (summa <= 0)
            throw new ArgumentException("Noguldītā summa nevar būt mazāka vai vienāda ar 0.");
        atlikums += summa;
    }

    // Izņem naudu no konta
    public void Iznemt(decimal summa) {
        if (summa <= 0)
            throw new ArgumentException("Izņemtā summa nevar būt mazāka vai vienāda ar 0.");
        if (summa > atlikums)
            throw new InvalidOperationException("Nepietiekams atlikums.");
        atlikums -= summa;
    }

    public void Paradit() {
        // Parāda konta informāciju konsolē
        Console.WriteLine($"Konta nr.: {numurs}");
        Console.WriteLine($"Īpašnieks: {ipasnieks}");
        Console.WriteLine($"Atlikums: {atlikums} EUR");
    }
}

class Program {
    private static BankasKonts? bankasKonts;

    public static void Main(string[] args) {
        while (true) {
            Console.WriteLine("\nLūdzu, izvēlieties darbību:");
            Console.WriteLine("1. Izveidot jaunu bankas kontu");
            Console.WriteLine("2. Noguldīt naudu kontā");
            Console.WriteLine("3. Izņemt naudu no konta");
            Console.WriteLine("4. Parādīt konta informāciju");
            Console.WriteLine("5. Dzēst kontu");
            Console.WriteLine("6. Iziet no sistēmas");

            Console.Write("Jūsu izvēle: ");
            string ievade = Console.ReadLine();
            Console.WriteLine();

            try {
                switch (ievade) {
                    case "1": //izveidot kontu
                        IzveidotKontu();
                        break;
                    case "2": //ielikt naudu konta
                        NogulditNaudu();
                        break;
                    case "3": //iznemt naudu
                        IznemtNaudu();
                        break;
                    case "4": //paradit konta info
                        bankasKonts.Paradit();
                        break;
                    case "5": //dzest kontu
                        DzestKontu();
                        break;
                    case "6": //beidz darbu
                        Console.WriteLine("Paldies par sadarbi :)");
                        return;
                    default:
                        Console.WriteLine("??? Nepareiza komanda, mēģini vēlreiz");
                        break;
                }
            } catch (Exception kluda) {
                Console.WriteLine($"Kļūda: {kluda.Message}");
            }
        }
    }

    // Izveido jaunu bankas kontu
    static void IzveidotKontu() {
        Console.Write("Ievadi savu vārdu: ");
        bankasKonts = new BankasKonts(Console.ReadLine());
    }

    // Nogūlda naudu kontā
    static void NogulditNaudu() {
        Console.Write("Ievadi naudas summu, ko vēlies noguldīt: ");
        bankasKonts.Noguldit(decimal.Parse(Console.ReadLine()));
        Console.WriteLine("Nauda veiksmīgi noguldīta.");
    }

    static void IznemtNaudu() { // Veic naudas izņemšanu no konta
        Console.Write("Ievadi naudas summu, ko vēlies izņemt: ");
        bankasKonts.Iznemt(decimal.Parse(Console.ReadLine()));
        Console.WriteLine("Nauda izņemta");
    }

    // Dzēš šobrīdējo kontu
    static void DzestKontu() {
        if (bankasKonts != null) {
            bankasKonts = null;
            Console.WriteLine("Konts veiksmīgi dzēsts.");
        } else {
            Console.WriteLine("Jums nepieder konts...");
        }
    }
}