namespace ConsoleApp1;
class Program
{
    /**
     * MARKUSS LABRENCIS
     * 3/31/2025 - 13:38
     */
    static void Main(string[] args)
    {
        string vards = "Markuss";
        TabulaGalva(vards);

        int[,] randomSkaitli = GeneretRandomMasivu(vards.Length, vards.Length, 1, 23);

        Tabula(randomSkaitli);

        Console.WriteLine();
        Console.WriteLine();

        string uzvards = "Labrencis";
        TabulaGalva(uzvards);

        int[,] randomSkaitli2 = TabulasMaina(randomSkaitli);

        Tabula(randomSkaitli2);
    }

    static void TabulasLinija(int svitras, int reizes)
    {
        for (int i = 0; i < reizes; i++)
        {
            Console.Write("*");
            for (int j = 0; j < svitras; j++)
            {
                Console.Write("_");
            }
        }

        Console.Write("*");
    }

    static void TabulasRinda(int[] rindasDati, int max, int min, int sum)
    {
        int rindas = rindasDati.Length;

        for (int j = 0; j < rindas; j++)
        {
            Console.Write($"| {rindasDati[j]} ");
        }

        Console.WriteLine($"| {max} | {min} | {sum} |");
    }

    static int[,] TabulasDati(string vards, string uzvards)
    {
        int minGarums = vards.Length;
        int maxGarums = vards.Length + uzvards.Length;

        Random rand = new Random();

        int rindas = maxGarums;
        int kolonnas = minGarums;

        int[,] dati = new int[rindas, kolonnas];

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                dati[i, j] = rand.Next(minGarums, maxGarums + 1);
            }
        }

        return dati;
    }

    static void TabulaGalva(string vards)
    {
        TabulasLinija(4, vards.Length + 2);
        Console.WriteLine();
        Console.Write("|");
        for (int i = 0; i < vards.Length; i++)
        {
            Console.Write(" " + vards[i] + " |");
        }

        Console.Write(" min | max | sum |");
        Console.WriteLine();
        TabulasLinija(4, vards.Length + 2);
        Console.WriteLine();
    }

    static void Tabula(int[,] dati)
    {
        for (int i = 0; i < dati.GetLength(0); i++)
        {
            int min = Int32.MaxValue;
            int max = Int32.MinValue;
            int sum = 0;

            for (int j = 0; j < dati.GetLength(1); j++)
            {
                int value = dati[i, j];
                sum += value;
                if (value > max) max = value;
                if (value < min) min = value;
            }

            if (i != 0)
            {
                Console.WriteLine();
            }

            TabulasRinda(DabutRinduDatus(dati, i), max, min, sum);
            TabulasLinija(4, dati.GetLength(1) + 2);
        }
    }

    static int[] DabutRinduDatus(int[,] dati, int rowIndex)
    {
        int columns = dati.GetLength(1);
        int[] rowData = new int[columns];

        for (int i = 0; i < columns; i++)
        {
            rowData[i] = dati[rowIndex, i];
        }

        return rowData;
    }

    static int[,] GeneretRandomMasivu(int rindas, int kolonnas, int min, int max)
    {
        Random rand = new Random();

        int[,] masivs = new int[rindas, kolonnas];

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                masivs[i, j] = rand.Next(min, max + 1);
            }
        }

        return masivs;
    }

    static int[,] TabulasMaina(int[,] masivs)
    {
        int rindas = masivs.GetLength(0);
        int kolonnas = masivs.GetLength(1);

        int[,] mainitaisMasivs = new int[kolonnas, rindas];

        for (int i = 0; i < rindas; i++)
        {
            for (int j = 0; j < kolonnas; j++)
            {
                mainitaisMasivs[j, i] = masivs[i, j];
            }
        }

        return mainitaisMasivs;
    }
}
