namespace ConsoleApp1;

class Program{
    //Ceturtais uzdevums, veidoja Markuss Labrencis 3.24.2025. Uz Windows 11 24H2 (26100.3476)
    static void Main(){
        string vards = "markuss";
        string uzvards = "labrencis";

        Console.WriteLine($"Mans vards ir {kapitalizet(vards)} un taja ir {vards.Length} simboli");
        Console.WriteLine($"Mans uzvards ir {kapitalizet(uzvards)} un taja ir {uzvards.Length} simboli");

        izvaditTabulu(vards, uzvards);
    }

    /**
     * kapitalize pirmo burtu teksta un parejos padara mazos
     */
    static string kapitalizet(string vards){
        if (string.IsNullOrEmpty(vards))
            return vards;

        return char.ToUpper(vards[0]) + vards.Substring(1).ToLower();
    }

    /**
     * izvada horizontalu liniju
     */
    static void horizontalaLinija(int vardsGarums){
        Console.Write("+-----+");

        for (int i = 0; i < vardsGarums; i++){
            Console.Write("-----+");
        }

        Console.Write("-----+-----+-----+-----+");
        Console.WriteLine();
    }

    static void izvaditTabulu(string vards, string uzvards){
        int min = vards.Length;
        int max = vards.Length + uzvards.Length;

        Random random = new Random();

        horizontalaLinija(vards.Length);

        Console.Write("| x |");

        for (int i = 0; i < vards.Length; i++){
            Console.Write($" {char.ToUpper(vards[i]).ToString().PadRight(3)}|");
        }

        Console.Write("   max |   min |   vid |   sum  |");
        Console.WriteLine();

        horizontalaLinija(vards.Length);

        for (int i = 0; i < uzvards.Length; i++){
            char charis = char.ToLower(uzvards[i]);

            int[] vardaGarums = new int[vards.Length];
            int summa = 0;
            int maks = 0;
            int mins = 100;

            Console.Write($"| {charis} |");

            for (int j = 0; j < vards.Length; j++){
                vardaGarums[j] = random.Next(min, max + 1);

                summa += vardaGarums[j];

                if (vardaGarums[j] > maks) maks = vardaGarums[j];
                if (vardaGarums[j] < mins) mins = vardaGarums[j];
                Console.Write($" {vardaGarums[j].ToString().PadLeft(3)} |");
            }

            double videjais = Math.Round((double)summa / vards.Length, 1);
            string videjaisFormatets = videjais.ToString("0.0");

            Console.Write($" {maks.ToString().PadLeft(3)} | {mins.ToString().PadLeft(3)} |{videjaisFormatets.PadLeft(5)} | {summa.ToString().PadLeft(3)} |");
            Console.WriteLine();

            horizontalaLinija(vards.Length);
        }
    }
}