﻿namespace ConsoleApp1;

// Bankas konta klase, kas nodrošina konta pārvaldības funkcionalitāti
class BankasKonts{
    // Automātiski ģenerēts unikāls konta numurs
    private string kontaNumurs = Guid.NewGuid().ToString();
    private string ipasniekaVards;
    private decimal atlikums;

    // Inicializē jaunu BankasKonts instanci
    public BankasKonts(string ipasnieks){
        ipasniekaVards = ipasnieks;
        atlikums = 0;
        Console.WriteLine($"Konts izveidots. Konta numurs: {kontaNumurs}");
    }

    // Destruktors, kas izpildās, kad konts tiek iznīcināts
    ~BankasKonts(){
        Console.WriteLine($"Konts ar numuru {kontaNumurs} tika izdzēsts.");
    }

    // Nogulda naudu kontā
    public void Noguldit(decimal summa){
        if (summa <= 0)
            throw new ArgumentException("Noguldītā summa nevar būt mazāka vai vienāda ar 0.");
        atlikums += summa;
    }

    // Izņem naudu no konta
    public void Iznemt(decimal summa){
        if (summa <= 0)
            throw new ArgumentException("Izņemtā summa nevar būt mazāka vai vienāda ar 0.");
        if (summa > atlikums)
            throw new InvalidOperationException("Nepietiekams atlikums.");
        atlikums -= summa;
    }

    // Parāda konta informāciju konsolē
    public void ParaditInformaciju(){
        Console.WriteLine($"Konta numurs: {kontaNumurs}");
        Console.WriteLine($"Īpašnieks: {ipasniekaVards}");
        Console.WriteLine($"Atlikums: {atlikums} EUR");
    }
}

class Program{
    // Pašreizējais bankas konts (atļauts tikai viens konts vienlaikus)
    private static BankasKonts bankasKonts;

    static void Main(){
        // Programmas ieejas punkts
        while (true){
            Console.WriteLine("\nLūdzu, izvēlieties darbību:");
            Console.WriteLine("1. Izveidot jaunu bankas kontu");
            Console.WriteLine("2. Noguldīt naudu kontā");
            Console.WriteLine("3. Izņemt naudu no konta");
            Console.WriteLine("4. Parādīt konta informāciju");
            Console.WriteLine("5. Dzēst kontu");
            Console.WriteLine("6. Iziet no sistēmas");

            Console.Write("Jūsu izvēle: ");
            string ievade = Console.ReadLine();
            Console.WriteLine();

            try{
                switch (ievade){
                    case "1":
                        IzveidotKontu();
                        break;
                    case "2":
                        NogulditNaudu();
                        break;
                    case "3":
                        IznemtNaudu();
                        break;
                    case "4":
                        ParaditInformaciju();
                        break;
                    case "5":
                        DzestKontu();
                        break;
                    case "6":
                        return;
                    default:
                        Console.WriteLine("Nederīga izvēle.");
                        break;
                }
            }
            catch (Exception ex){
                Console.WriteLine($"Kļūda: {ex.Message}");
            }
        }
    }

    // Izveido jaunu bankas kontu
    static void IzveidotKontu(){
        Console.Write("Ievadi savu vārdu: ");
        string vards = Console.ReadLine();

        bankasKonts = new BankasKonts(vards);
    }

    // Veic naudas noguldīšanu kontā
    static void NogulditNaudu(){
        Console.Write("Ievadi summu, ko noguldīt: ");
        decimal summa = decimal.Parse(Console.ReadLine());
        bankasKonts.Noguldit(summa);
        Console.WriteLine("Nauda veiksmīgi noguldīta.");
    }

    // Veic naudas izņemšanu no konta
    static void IznemtNaudu(){
        Console.Write("Ievadi summu, ko izņemt: ");
        decimal summa = decimal.Parse(Console.ReadLine());
        bankasKonts.Iznemt(summa);
        Console.WriteLine("Nauda veiksmīgi izņemta.");
    }

    // Parāda pašreizējā konta informāciju
    static void ParaditInformaciju(){
        bankasKonts.ParaditInformaciju();
    }

    // Dzēš pašreizējo kontu
    static void DzestKontu(){
        if (bankasKonts == null){
            Console.WriteLine("Nav izveidots konts, ko dzēst.");
            return;
        }

        bankasKonts = null;
        GC.Collect(); // piespied GC, lai destruktors aktivējas uzreiz
        Console.WriteLine("Konts veiksmīgi dzēsts.");
    }
}