<?php
include "conn.php"; 
$sql = "
SELECT
id,
vards,
epasts,
dzdiena,
valsts,
dzimums,
intereses,
komentari
FROM 
aleksandrs_j_php
";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="lv">
<head>
<meta charset="utf-8">
<title>Tabula</title>
<style>
  body { font-family: Arial, sans-serif; margin: 30px; font-size: 16px; }
  h1 { color: #333; }
  input { padding: 8px; margin-bottom: 12px; width: 300px; font-size: 15px; }
  table { border-collapse: collapse; width: 95%; font-size: 15px; }
  th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
  th { background: #4CAF50; color: white; cursor: pointer; }
  tr:hover { background: #f9f9f9; }
  #msg { margin-top: 10px; padding: 10px; border-radius: 6px; display: none; width: fit-content; }
  .ok { background: #d4edda; color: #155724; }
  .err { background: #f8d7da; color: #721c24; }
  button { cursor: pointer; padding: 5px 10px; }
</style>
</head>
<body>

<h1>Visi lietotāji</h1>

<form action="ievade.php">
  <button type="submit">Jauns lietotājs</button>
</form>

<br>
<input type="text" id="filter" placeholder="Filtrēt pēc vārda..." onkeyup="filterTable()">

<table id="myTable">
<thead>
<tr>
<th onclick="sortTable(0)">ID</th>
<th onclick="sortTable(1)">Vārds</th>
<th onclick="sortTable(2)">E-pasts</th>
<th onclick="sortTable(3)">Dzimšanas diena</th>
<th onclick="sortTable(4)">Valsts</th>
<th onclick="sortTable(5)">Dzimums</th>
<th onclick="sortTable(6)">Intereses</th>
<th onclick="sortTable(7)">Komentāri</th>
<th>Darbības</th>
</tr>
</thead>
<tbody>
<?php
if ($result->num_rows > 0) {
  while($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>".$row['id']."</td>";
    echo "<td>".$row['vards']."</td>";
    echo "<td>".$row['epasts']."</td>";
    echo "<td>".$row['dzdiena']."</td>";
    echo "<td>".$row['valsts']."</td>";
    echo "<td>".$row['dzimums']."</td>";
    echo "<td>".$row['intereses']."</td>";
    echo "<td>".$row['komentari']."</td>";
    echo "<td>
            <form action='delete.php' style='display:inline'>
              <input type='hidden' name='id' value='".$row['id']."'>
              <button type='submit'>Dzēst</button>
            </form>
            <form action='ievade.php' style='display:inline'>
              <input type='hidden' name='id' value='".$row['id']."'>
              <button type='submit'>Labot</button>
            </form>
          </td>";
    echo "</tr>";
  }
} else {
  echo "<tr><td colspan='9'>Nav datu</td></tr>";
}
$conn->close();
?>
</tbody>
</table>

<div id="msg"></div>

<script>
// --- Paziņojumu funkcija ---
function showMsg(text, cls) {
  const m = document.getElementById('msg');
  m.innerText = text;
  m.className = cls;
  m.style.display = 'block';
  setTimeout(() => m.style.display = 'none', 2500);
}

// --- Filtrēšana ---
function filterTable() {
  let f = document.getElementById("filter").value.toUpperCase();
  let tr = document.querySelectorAll("#myTable tbody tr");
  let found = false;
  for (let i = 0; i < tr.length; i++) {
    let td = tr[i].getElementsByTagName("td")[1]; // kolonna "Vārds"
    if (td && td.textContent.toUpperCase().includes(f)) {
      tr[i].style.display = "";
      found = true;
    } else {
      tr[i].style.display = "none";
    }
  }
  if (f === "") showMsg("Filtrs notīrīts", "ok");
  else if (found) showMsg("Atrasti ieraksti", "ok");
  else showMsg("Nav atrasts", "err");
}

// --- Kārtošana ---
function sortTable(n) {
  let table = document.getElementById("myTable");
  let rows = Array.from(table.rows).slice(1); // bez header
  let asc = table.dataset.sort !== "asc";
  table.dataset.sort = asc ? "asc" : "desc";
  rows.sort((a, b) => {
    let x = a.cells[n].innerText.toLowerCase();
    let y = b.cells[n].innerText.toLowerCase();
    return asc ? x.localeCompare(y) : y.localeCompare(x);
  });
  rows.forEach(r => table.tBodies[0].appendChild(r));
  showMsg("Tabula sakārtota", "ok");
}
</script>

</body>
</html>
