//  Paziņojumu funkcija 
function showMsg(text, cls) {
  const m = document.getElementById('message');
  m.innerText = text;
  m.className = cls;
  m.style.display = 'block';
  setTimeout(() => m.style.display = 'none', 2500);
}

//  Filtrēšana
function filterTable() {
  let f = document.getElementById("filter").value.toUpperCase();
  let tr = document.querySelectorAll("#myTable tbody tr");
  let found = false;

  for (let i = 0; i < tr.length; i++) {
    let td = tr[i].getElementsByTagName("td")[1]; 
    if (td && td.textContent.toUpperCase().includes(f)) {
      tr[i].style.display = "";
      found = true;
    } else {
      tr[i].style.display = "none";
    }
  }

  if (f === "") showMsg("Filtrs notīrīts", "ok");
  else if (found) showMsg("Atrasti ieraksti", "ok");
  else showMsg("Nav atrasts", "error");
}

//  Kārtošana 
function sortTable(n) {
  let table = document.getElementById("myTable");
  let rows = Array.from(table.rows).slice(1); 
  let asc = table.dataset.sort !== "asc";
  table.dataset.sort = asc ? "asc" : "desc";

  rows.sort((a, b) => {
    let x = a.cells[n].innerText.toLowerCase();
    let y = b.cells[n].innerText.toLowerCase();
    return asc ? x.localeCompare(y) : y.localeCompare(x);
  });

  rows.forEach(r => table.tBodies[0].appendChild(r));
  showMsg("Tabula sakārtota", "ok");
}
