document.addEventListener("DOMContentLoaded", () => {
    const table = document.querySelector("table");
    const tbody = table.querySelector("tbody");

    // --- KĀRTOŠANA ---
    const getCellValue = (tr, idx) => tr.children[idx].innerText.toLowerCase();

    function sortTable(idxArr) {
        const rows = Array.from(tbody.querySelectorAll("tr"));
        rows.sort((a, b) => {
            for (let idx of idxArr) {
                const valA = getCellValue(a, idx);
                const valB = getCellValue(b, idx);
                if (valA < valB) return -1;
                if (valA > valB) return 1;
            }
            return 0;
        });
        rows.forEach(r => tbody.appendChild(r));
    }

    // --- FILTRĒŠANA ---
    function filterTable() {
        const dateFilter = document.getElementById("filterDate").value.trim();
        const langFilter = document.getElementById("filterLang").value.trim().toLowerCase();
        const transFilter = document.getElementById("filterTrans").value.trim().toLowerCase();

        Array.from(tbody.querySelectorAll("tr")).forEach(row => {
            const birth = row.children[2].innerText;
            const lang = row.children[4].innerText.toLowerCase();
            const trans1 = row.children[5].innerText.toLowerCase();
            const trans2 = row.children[6].innerText.toLowerCase();
            const trans3 = row.children[7].innerText.toLowerCase();

            let visible = true;

            if (dateFilter && !birth.includes(dateFilter)) visible = false;
            if (langFilter && !lang.includes(langFilter)) visible = false;
            if (transFilter && !(trans1.includes(transFilter) || trans2.includes(transFilter) || trans3.includes(transFilter))) visible = false;

            row.style.display = visible ? "" : "none";
        });
    }

    // --- POGU SAISTĪŠANA ---
    document.getElementById("sortName").addEventListener("click", () => sortTable([0]));
    document.getElementById("sortSurname").addEventListener("click", () => sortTable([1]));
    document.getElementById("sortNameSurname").addEventListener("click", () => sortTable([0, 1]));

    // --- FILTRI ---
    document.getElementById("applyFilters").addEventListener("click", filterTable);
});
