function formatInputText(input) {
  const value = input.value;
  let formatted = "";
  let makeUpper = true; // pirmā burta vienmēr ir liels

  for (let i = 0; i < value.length; i++) {
    const char = value[i];

    if (/[a-zA-Zā-žĀ-Žа-яА-ЯёЁ]/.test(char)) {
      // ja simbols ir burts
      formatted += makeUpper ? char.toUpperCase() : char.toLowerCase();
      makeUpper = false;
    } else {
      // ja ir atstarpe vai domuzīme — nākamais burts būs liels
      formatted += char;
      if (char === " " || char === "-") {
        makeUpper = true;
      }
    }
  }

  // saglabājam kursora pozīciju
  const pos = input.selectionStart;
  input.value = formatted;
  input.setSelectionRange(pos, pos);
}

// pievienojam apstrādātājus pēc lapas ielādes
document.addEventListener("DOMContentLoaded", () => {
  const textInputs = document.querySelectorAll("#fname, #lname");
  
  textInputs.forEach(input => {
    input.addEventListener("input", () => formatInputText(input));
  });
});
