function extraAction() {
  const fname = document.getElementById("fname");
  const lname = document.getElementById("lname");
  const birthday = document.getElementById("birthday");
  const languages = document.querySelectorAll('input[name="fav_language"]');
  
  let isValid = true;

  // Notīrīt iepriekšējās kļūdas
  [fname, lname, birthday].forEach(el => el.classList.remove("error"));

  // Vārda un uzvārda pārbaude (ne mazāk kā 5 simboli, atstarpes netiek skaitītas)
  const validateText = (input) => {
    const cleanValue = input.value.replace(/\s/g, "");
    if (cleanValue.length < 5) {
      input.classList.add("error");
      isValid = false;
    } else {
      input.classList.remove("error");
    }
  };

  validateText(fname);
  validateText(lname);

  // Valodas izvēles pārbaude
  const langSelected = Array.from(languages).some(r => r.checked);
  languages.forEach(radio => {
    if (!langSelected) {
      radio.classList.add("error");
    } else {
      radio.classList.remove("error");
    }
  });
  if (!langSelected) isValid = false;

  // Datuma pārbaude
  const today = new Date();
  const minDate = new Date(today);
  minDate.setFullYear(today.getFullYear() - 20);

  if (!birthday.value) {
    birthday.classList.add("error");
    isValid = false;
  } else {
    const inputDate = new Date(birthday.value);
    if (inputDate > today || inputDate < minDate) {
      birthday.classList.add("error");
      isValid = false;
    } else {
      birthday.classList.remove("error");
    }
  }

  // Ja ir kļūdas — parādīt kopēju paziņojumu
  if (!isValid) {
    alert("Pārbaudiet ievadītos datus!");
  }

  return isValid;
}

// Pievienot notikuma apstrādātāju
document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("mainForm");
  form.addEventListener("submit", function(event) {
    if (!extraAction()) {
      event.preventDefault();
    }
  });
});
