document.addEventListener("DOMContentLoaded", () => {
  const table = document.querySelector("table");
  const tbody = table.querySelector("tbody");

  // Filtra atiestatīšana (parāda visas rindas)
  function clearFilter() {
    tbody.querySelectorAll("tr").forEach(row => {
      row.style.display = ""; // atjauno standarta attēlojumu
    });
  }

  // Galvenā meklēšanas funkcija
  function searchTable() {
    clearFilter();
    const query = document.getElementById("searchInput").value.trim().toLowerCase();

    if (!query) return; // ja lauks ir tukšs — parādām visas rindas

    tbody.querySelectorAll("tr").forEach(row => {
      const text = row.innerText.toLowerCase();
      // ja rindā nav meklējamās vērtības — paslēpjam
      if (!text.includes(query)) {
        row.style.display = "none";
      }
    });
  }

  // Poga "Meklēt"
  document.getElementById("searchButton").addEventListener("click", searchTable);
});
