<!DOCTYPE HTML>
<html lang="lv">
<head>
<meta charset="UTF-8">
<title>Datu rediģēšana</title>
<style>
  input.error, select.error {
    background-color: #ffcccc;
  }
  input[type="radio"].error + label {
    background-color: #ffcccc;
    border-radius: 4px;
    padding: 2px 4px;
  }
  #message {
    margin-top: 20px;
    font-weight: bold;
    font-size: 18px;
    white-space: pre-wrap;
  }
  #message.success {
    color: green;
  }
  #message.error {
    color: red;
  }
</style>
</head>
<body>

<?php
include "puk_mg_10_09_2025_conn_b1.php";

// Noklusējuma vērtības
$vehicle1 = $vehicle2 = $vehicle3 = $fav_language = $cars = "";
$lname = $_GET['lname'] ?? "";
$fname = $_GET['fname'] ?? "";
$birth = $_GET['birth'] ?? "";
$id = $_GET['id'] ?? "";

// Ja ir ID — ielasa datus no DB
if (!empty($id)) {
    $sql = "SELECT * FROM Maksims_b1 WHERE id=" . intval($id);
    $result = $conn->query($sql);
    if ($result && $row = $result->fetch_assoc()) {
        $fname = $row["fname"];
        $lname = $row["lname"];
        $birth = $row["birth"];
        $vehicle1 = $row["trans1"];
        $vehicle2 = $row["trans2"];
        $vehicle3 = $row["trans3"];
        $cars = $row["cars"];
        $fav_language = $row["fav_l"];
    }
}
$conn->close();
?>

<!-- FORMA DATU REDIĢĒŠANAI -->
<form id="mainForm">
  <input type="hidden" name="id" value="<?= htmlspecialchars($id) ?>">

  <label for="fname">Vārds:</label>
  <input type="text" id="fname" name="fname" value="<?= htmlspecialchars($fname) ?>"><br><br>

  <label for="lname">Uzvārds:</label>
  <input type="text" id="lname" name="lname" value="<?= htmlspecialchars($lname) ?>"><br><br>

  <label for="birthday">Dzimšanas datums:</label>
  <input type="date" id="birthday" name="birthday" value="<?= htmlspecialchars($birth) ?>"><br><br>

  <label for="cars">Izvēlies auto:</label><br>
  <select name="cars" id="cars">
    <option value="Nav Datu"></option>
    <option value="volvo" <?= $cars == "volvo" ? "selected" : "" ?>>Volvo</option>
    <option value="saab" <?= $cars == "saab" ? "selected" : "" ?>>Saab</option>
    <option value="mercedes" <?= $cars == "mercedes" ? "selected" : "" ?>>Mercedes</option>
    <option value="audi" <?= $cars == "audi" ? "selected" : "" ?>>Audi</option>
  </select><br><br>

  <input type="checkbox" id="vehicle1" name="vehicle1" value="Ir" <?= $vehicle1 == "Ir" ? "checked" : "" ?>>
  <label for="vehicle1">Man ir velosipēds</label><br>

  <input type="checkbox" id="vehicle2" name="vehicle2" value="Ir" <?= $vehicle2 == "Ir" ? "checked" : "" ?>>
  <label for="vehicle2">Man ir mašīna</label><br>

  <input type="checkbox" id="vehicle3" name="vehicle3" value="Ir" <?= $vehicle3 == "Ir" ? "checked" : "" ?>>
  <label for="vehicle3">Man ir laiva</label><br><br>

  <input type="radio" id="html" name="fav_language" value="HTML" <?= $fav_language == "HTML" ? "checked" : "" ?>>
  <label for="html">HTML</label><br>

  <input type="radio" id="css" name="fav_language" value="CSS" <?= $fav_language == "CSS" ? "checked" : "" ?>>
  <label for="css">CSS</label><br>

  <input type="radio" id="javascript" name="fav_language" value="JavaScript" <?= $fav_language == "JavaScript" ? "checked" : "" ?>>
  <label for="javascript">JavaScript</label><br><br>

  <input type="reset" value="Notīrīt">
  <input type="submit" value="Saglabāt">
</form>

<!-- Vietne paziņojumiem -->
<div id="message"></div>

<script>
// Kad lietotājs nospiež “Saglabāt”
document.getElementById("mainForm").addEventListener("submit", async function(event) {
  event.preventDefault();
  if (!extraAction()) return;

  const formData = new FormData(this);
  const msg = document.getElementById("message");
  msg.textContent = "Dati tiek saglabāti...";
  msg.className = "";

  try {
    const response = await fetch("puk_mg_10_09_2025_sendDB_b1.php", {
      method: "POST",
      body: formData
    });
    const result = await response.text();

    if (result.includes("Veiksmigi") || result.includes("Das is fantastich")) {
      msg.textContent = "Veiksmīgi saglabāts!";
      msg.className = "success";
      setTimeout(() => {
        window.location.href = "puk_mg_10_09_2025_output_b5.php";
      }, 2000);
    } else {
      msg.textContent = "Kļūda saglabājot datus!\n\n" + result;
      msg.className = "error";
    }
  } catch (e) {
    msg.textContent = "Servera kļūda!\n\n" + e;
    msg.className = "error";
  }
});

// Validācijas funkcija (tā pati, kas iepriekšējā formā)
function extraAction() {
  const fname = document.getElementById("fname");
  const lname = document.getElementById("lname");
  const birthday = document.getElementById("birthday");
  const languages = document.querySelectorAll('input[name="fav_language"]');
  let isValid = true;

  [fname, lname, birthday].forEach(el => el.classList.remove("error"));
  languages.forEach(r => r.classList.remove("error"));

  const validateText = (input) => {
    const clean = input.value.replace(/\s/g, "");
    if (clean.length < 5) {
      input.classList.add("error");
      isValid = false;
    }
  };

  validateText(fname);
  validateText(lname);

  const langSelected = Array.from(languages).some(r => r.checked);
  if (!langSelected) {
    languages.forEach(r => r.classList.add("error"));
    isValid = false;
  }

  const today = new Date();
  const minDate = new Date(today);
  minDate.setFullYear(today.getFullYear() - 20);

  if (!birthday.value) {
    birthday.classList.add("error");
    isValid = false;
  } else {
    const inputDate = new Date(birthday.value);
    if (inputDate > today || inputDate < minDate) {
      birthday.classList.add("error");
      isValid = false;
    }
  }

  if (!isValid) alert("Pārbaudiet ievadītos datus!");
  return isValid;
}
</script>

</body>
</html>
