<!DOCTYPE HTML>
<html>  
<head>
<meta charset="UTF-8">
<title>Ievades forma ar pārbaudi</title>
<style>
  /* Ievades lauku kļūdu stils */
  input.error, select.error {
    background-color: #ffcccc;
  }
  input[type="radio"].error + label {
    background-color: #ffcccc;
    border-radius: 4px;
    padding: 2px 4px;
  }

  /* Ziņojuma stils */
  #message {
    margin-top: 20px;
    font-weight: bold;
    font-size: 18px;
  }
  #message.success {
    color: green;
  }
  #message.error {
    color: red;
  }
</style>
</head>
<body>

<!-- GALVENĀ FORMA -->
<form id="mainForm">
  <label for="fname">Vārds:</label>
  <input type="text" id="fname" name="fname"><br><br>

  <label for="lname">Uzvārds:</label>
  <input type="text" id="lname" name="lname"><br><br>

  <label for="birthday">Dzimšanas datums:</label>
  <input type="date" id="birthday" name="birthday"><br><br>

  <label for="cars">Izvēlies auto:</label><br>
  <select name="cars" id="cars">
  <option value="Nav Datu"></option>
    <option value="volvo">Volvo</option>
    <option value="saab">Saab</option>
    <option value="mercedes">Mercedes</option>
    <option value="audi">Audi</option>
  </select><br><br>

  <!-- Transportlīdzekļi -->
  <input type="checkbox" id="vehicle1" name="vehicle1" value="Ir">
  <label for="vehicle1"> Man ir velosipēds</label><br>

  <input type="checkbox" id="vehicle2" name="vehicle2" value="Ir">
  <label for="vehicle2"> Man ir automašīna</label><br>

  <input type="checkbox" id="vehicle3" name="vehicle3" value="Ir">
  <label for="vehicle3"> Man ir laiva</label><br><br>

  <!-- Programmēšanas valodu izvēle -->
  <input type="radio" id="html" name="fav_language" value="HTML">
  <label for="html">HTML</label><br>

  <input type="radio" id="css" name="fav_language" value="CSS">
  <label for="css">CSS</label><br>

  <input type="radio" id="javascript" name="fav_language" value="JavaScript">
  <label for="javascript">JavaScript</label><br><br>

  <input type="reset" value="Notīrīt">
  <input type="submit" value="Iesniegt">
</form>

<!-- Vietne paziņojumiem -->
<div id="message"></div>

<script>
// Noklausāmies formas iesniegšanu
document.getElementById("mainForm").addEventListener("submit", async function(event) {
  event.preventDefault(); // Neļaujam formai pārlādēt lapu
  if (!extraAction()) return; // Ja validācija neiztur, neturpinām

  const form = event.target;
  const formData = new FormData(form);
  const messageBox = document.getElementById("message");

  try {
    // Nosūtām datus uz PHP failu
    const response = await fetch("puk_mg_10_09_2025_insert_b1.php", {
      method: "POST",
      body: formData
    });

    // Sagaidām atbildi no servera kā tekstu
    const result = await response.text();

    // Ja PHP paziņojums satur “Veiksmīgi” vai “Das is fantastich”
    if (result.includes("Veiksmigi") || result.includes("Das is fantastich")) {
      messageBox.textContent = "Veiksmīgi pievienots!";
      messageBox.className = "success";

      // Pēc 2 sekundēm pārsūtām uz citu lapu
      setTimeout(() => {
        window.location.href = "puk_mg_10_09_2025_output_b5.php";
      }, 2000);
    } else {
      messageBox.textContent = "Kļūda pievienojot!";
      messageBox.className = "error";
    }
  } catch (error) {
    // Ja notika kļūda servera vai tīkla līmenī
    messageBox.textContent = "Servera kļūda!";
    messageBox.className = "error";
    console.error(error);
  }
});


// Funkcija datu pārbaudei pirms nosūtīšanas
function extraAction() {
  const fname = document.getElementById("fname");
  const lname = document.getElementById("lname");
  const birthday = document.getElementById("birthday");
  const languages = document.querySelectorAll('input[name="fav_language"]');
  
  let isValid = true;

  // Notīrām iepriekšējās kļūdas
  [fname, lname, birthday].forEach(el => el.classList.remove("error"));
  languages.forEach(radio => radio.classList.remove("error"));

  // Pārbaude: vārds un uzvārds — vismaz 5 simboli bez atstarpēm
  const validateText = (input) => {
    const cleanValue = input.value.replace(/\s/g, "");
    if (cleanValue.length < 5) {
      input.classList.add("error");
      isValid = false;
    }
  };

  validateText(fname);
  validateText(lname);

  // Pārbaude: vai ir izvēlēta valoda
  const langSelected = Array.from(languages).some(r => r.checked);
  if (!langSelected) {
    languages.forEach(r => r.classList.add("error"));
    isValid = false;
  }

  // Pārbaude: dzimšanas datums (vismaz 20 gadi)
  const today = new Date();
  const minDate = new Date(today);
  minDate.setFullYear(today.getFullYear() - 20);

  if (!birthday.value) {
    birthday.classList.add("error");
    isValid = false;
  } else {
    const inputDate = new Date(birthday.value);
    if (inputDate > today || inputDate < minDate) {
      birthday.classList.add("error");
      isValid = false;
    }
  }

  // Ja kaut kas nav kārtībā — paziņojums
  if (!isValid) {
    alert("Pārbaudiet ievadītos datus!");
  }

  return isValid; // Ja false — forma netiks sūtīta
}
</script>

</body>
</html>
