using System;

class Program
{
    static void Main(string[] args)
    {
        // Lietotājs ievada vārdu un uzvārdu
        Console.WriteLine("Ievadiet vārdu");
        string vards = Console.ReadLine(); 
        Console.WriteLine("Ievadiet uzvārdu");
        string uzvards = Console.ReadLine(); 
        Console.WriteLine();

        // Izveido tabulas līniju un izdrukā tabulas galvu
        TabulasLinija(vards.Length); 
        Console.WriteLine();
        TabulasGalva(vards); 

        // Izveido 2D masīvu ar datiem un izdrukā pirmo tabulu
        int[,] masivs = TabulasDati(vards, uzvards); // Izveido masīvu ar nejaušiem skaitļiem
        Tabula(masivs); // Izdrukā tabulu ar datiem

        // Izveido otro masīvu un izdrukā otro tabulu
        Console.WriteLine("Tabulas maina");
        Console.WriteLine();

        int[,] masivs2 = TabulasDati2(vards, uzvards); // Izveido otro masīvu ar citiem nejaušiem datiem

        
        
        TabulasLinija(uzvards.Length);
        Console.WriteLine();
        TabulasGalva2(uzvards); 
        tabulasmaina(masivs2); // Izdrukā otro tabulu ar datiem

        Console.ReadKey(); 
    }

    // Funkcija, kas izdrukā tabulas līniju ar zvaigznēm un svītrām
    static void TabulasLinija(int svitras)
    {
        
        for (int i = 0; i < svitras + 3; i++) 
        {
            Console.Write("*");
            for (int j = 0; j < 15; j++) 
            {
                Console.Write("-");
            }
        }
        Console.Write("*"); 
    }

    // Funkcija, kas izdrukā tabulas galvu (pirmajā rindā)
    static void TabulasGalva(string vards)
    {
        
        Console.Write("|\t");
        foreach (char c in vards) 
        {
            Console.Write(c + "\t|\t"); 
        }

        
        Console.WriteLine("min\t|\tmax\t|\tsum\t|");

       
        TabulasLinija(vards.Length); 
        Console.WriteLine(); 
    }

    // Funkcija, kas izveido masīvu ar nejaušiem skaitļiem
    static int[,] TabulasDati(string vards, string uzvards)
    {
        int rinduSkaits = uzvards.Length; // Rindas skaits ir uzvārda garums
        int kolonnuSkaits = vards.Length; // Kolonnas skaits ir vārda garums
        int[,] masivs = new int[rinduSkaits, kolonnuSkaits]; // Izveido 2D masīvu
        Random random = new Random(); // Nejaušības ģenerators

        // Ģenerē nejaušus skaitļus masīvā
        for (int i = 0; i < rinduSkaits; i++)
        {
            for (int j = 0; j < kolonnuSkaits; j++)
            {
                masivs[i, j] = random.Next(vards.Length, vards.Length + uzvards.Length+1); // Nejauši skaitļi
            }
        }
        return masivs; // Atgriež izveidoto masīvu
    }

    // Funkcija, kas izdrukā tabulu un aprēķina min, max un sum katrai rindai
    static void Tabula(int[,] masivs)
    {
        // Iterē pa 2D masīvu un izdrukā katru rindu
        for (int i = 0; i < masivs.GetLength(0); i++) // Pa rindām
        {
            int max = int.MinValue;
            int min = int.MaxValue;
            int sum = 0;

            // Izdrukā katru skaitli rindā un aprēķina min, max un sum
            Console.Write("|\t");
            for (int j = 0; j < masivs.GetLength(1); j++) 
            {
                Console.Write(masivs[i, j] + "\t|\t"); // Izdrukā katru skaitli un atdalītāju
                sum += masivs[i, j]; // Sākotnējais summas aprēķins
                max = Math.Max(max, masivs[i, j]); // Atrast maksimumu
                min = Math.Min(min, masivs[i, j]); // Atrast minimumu
            }

            // Izdrukā min, max un sum
            Console.WriteLine($"{min}\t|\t{max}\t|\t{sum}\t|");

            // Izveido atdalītāju pēc katras rindas
            TabulasLinija(masivs.GetLength(1)); // Izveido atdalītāju pēc katras rindas
            Console.WriteLine();
        }
    }

    // Funkcija, kas izveido otro masīvu ar nejaušiem skaitļiem
    static int[,] TabulasDati2(string vards, string uzvards)
    {
        int rinduSkaits = vards.Length; 
        int kolonnuSkaits = uzvards.Length; 
        int[,] masivs2 = new int[rinduSkaits, kolonnuSkaits]; // Izveido 2D masīvu
        Random random = new Random(); 

        // Ģenerē nejaušus skaitļus masīvā
        for (int i = 0; i < rinduSkaits; i++)
        {
            for (int j = 0; j < kolonnuSkaits; j++)
            {
                masivs2[i, j] = random.Next(vards.Length, vards.Length + uzvards.Length+1); 
            }
        }
        return masivs2; // Atgriež otro masīvu
    }

    // Funkcija, kas izdrukā otro tabulu un aprēķina min, max un sum
    static void tabulasmaina(int[,] masivs2)
    {
        for (int i = 0; i < masivs2.GetLength(0); i++) 
        {
            int max = int.MinValue;
            int min = int.MaxValue;
            int sum = 0;

            // Izdrukā katru skaitli rindā un aprēķina min, max un sum
            Console.Write("|\t ");
            for (int j = 0; j < masivs2.GetLength(1); j++) // Pa kolonnām
            {
                Console.Write(masivs2[i, j] + "\t|\t"); // Izdrukā katru skaitli un atdalītāju
                sum += masivs2[i, j]; 
                max = Math.Max(max, masivs2[i, j]);
                min = Math.Min(min, masivs2[i, j]); 
            }

            // Izdrukā min, max un sum
            Console.WriteLine($"{min}\t|\t{max}\t|\t{sum}\t|");

            // Izveido atdalītāju pēc katras rindas
            TabulasLinija(masivs2.GetLength(1)); 
            Console.WriteLine(); 
        }
    }

    // Funkcija, kas izdrukā otro tabulas galvu (pirmo rindas daļu)
    static void TabulasGalva2(string uzvards)
    {
        // Izdrukā pirmo rindas daļu ar katru uzvārda burtu
        Console.Write("|\t");
        foreach (char c in uzvards) 
        {
            Console.Write(c + "\t|\t"); 
        }

       
        Console.WriteLine("min\t|\tmax\t|\tsum\t|");

        // Izdrukā atdalītāju pēc tabulas galvas
        TabulasLinija(uzvards.Length);
        Console.WriteLine();
    }
}
