using System;

class Program
{
    static void Main(string[] args)
    {
        //  ievada savu vārdu
        Console.Write("Ievadi vārdu: ");
        string vards = Console.ReadLine();

        //  ievada savu uzvārdu
        Console.Write("Ievadi uzvārdu: ");
        string uzvards = Console.ReadLine();

        // Izsauc funkciju, lai izveidotu tabulu ar ievadīto vārdu un uzvārdu
        PrintTable(vards, uzvards);

        // Apmaina vietām vārdu un uzvārdu un pārveido tos ar mainīgiem burtiem
        string mainitsVards = ConvertToAlternatingCase(uzvards);
        string mainitsUzvards = ConvertToAlternatingCase(vards);

        // Izsauc funkciju, lai izveidotu tabulu ar pārveidotajiem vārdiem
        PrintTable(mainitsVards, mainitsUzvards);

        Console.ReadKey();
    }

    // Funkcija, kas pārveido tekstu  lai burti mainītos starp lielajiem un mazajiem burtiem
    static string ConvertToAlternatingCase(string input)
    {
        char[] characters = input.ToLower().ToCharArray();
        for (int i = 0; i < characters.Length; i++)
        {
            if (i % 2 == 0) 
                characters[i] = char.ToUpper(characters[i]);
        }
        return new string(characters);
    }

    static void PrintTable(string vards, string uzvards)
    {
        int vardaGarums = vards.Length;  // Vārda garums
        int uzvardaGarums = uzvards.Length;  // Uzvārda garums
        int kopejaisGarums = vardaGarums + uzvardaGarums; // Kopējais garums

        Random rand = new Random(); // Izveido random skaitlu generatoru

        int cellWidth = 6; // Vienas šūnas platums
        int tableWidth = (vardaGarums + 4) * cellWidth + 6; // Kopējais tabulas platums

        // Izvada tabulas augšējo līniju
        Console.WriteLine("*" + new string('=', tableWidth - 2) + "*");

        // izvada tabulas 1 rindu 
        Console.Write("| X   | ");
        foreach (char c in vards.ToUpper()) // Izvada vārdā esošos burtus
            Console.Write($"{c,-4}| ");
        Console.WriteLine("SUM  | MIN  | MAX  |");

        // Atdalītāja līnija pēc galvenes
        Console.WriteLine("+" + new string('-', tableWidth - 2) + "+");

        // Masīvi, lai glabātu SUM, MIN un MAX 
        int[] columnSums = new int[vardaGarums];
        int[] columnMins = new int[vardaGarums];
        int[] columnMaxs = new int[vardaGarums];

        // pieskir lilumu MIN un MAX
        for (int j = 0; j < vardaGarums; j++)
        {
            columnMins[j] = int.MaxValue;
            columnMaxs[j] = int.MinValue;
        }

        // Mainīgie, kas glabā kopējos SUM, MIN un MAX vērtības
        int kopejalSum = 0, kopejalMin = int.MaxValue, kopejalMax = int.MinValue;

        // iziet cauri uzvārdam un aizpilda tabulu
        for (int i = 0; i < uzvardaGarums; i++)
        {
            Console.Write($"| {uzvards[i],-3} | "); // Izvada uzvārda burtu
            int[] cipari = new int[vardaGarums];
            int rindasMax = int.MinValue, rindasMin = int.MaxValue, rindasSum = 0;

            // Aizpilda rindas ar random skaitļiem
            for (int j = 0; j < vardaGarums; j++)
            {
                cipari[j] = rand.Next(vardaGarums, kopejaisGarums + 1); // Ģenerē nejaušu skaitli
                rindasSum += cipari[j]; // Saskaita rindas SUM
                rindasMax = Math.Max(rindasMax, cipari[j]); // Atrod rindas MAX
                rindasMin = Math.Min(rindasMin, cipari[j]); // Atrod rindas MIN

                columnSums[j] += cipari[j]; // Pievieno kolonnu SUM
                columnMaxs[j] = Math.Max(columnMaxs[j], cipari[j]); // Pievieno kolonnu MAX
                columnMins[j] = Math.Min(columnMins[j], cipari[j]); // Pievieno kolonnu MIN

                Console.Write($"{cipari[j],-4}| "); // Izvada nejaušo skaitli tabulā
            }

            kopejalSum += rindasSum;
            kopejalMax = Math.Max(kopejalMax, rindasMax);
            kopejalMin = Math.Min(kopejalMin, rindasMin);

            Console.WriteLine($"{rindasSum,-4} |  {rindasMin,-4}|  {rindasMax,-4}|");

            // atdala rindas
            if (i < uzvardaGarums - 1)
            {
                Console.Write("+");
                for (int j = 0; j < vardaGarums + 4; j++)
                    Console.Write("----+");
                Console.WriteLine("----+----+----+");
            }
        }

        // atdala rindas
        Console.Write("*");
        for (int j = 0; j < vardaGarums + 4; j++)
            Console.Write("====*");
        Console.WriteLine("====*====*====*");

        // SUM rinda
        Console.Write("| SUM | ");
        for (int j = 0; j < vardaGarums; j++)
            Console.Write($"{columnSums[j],-4}| ");
        Console.WriteLine($"{kopejalSum,-4}| *    | *    |");

        // atdala rindas
        Console.Write("*");
        for (int j = 0; j < vardaGarums + 4; j++)
            Console.Write("====*");
        Console.WriteLine("====*====*====*");

        // MIN rinda
        Console.Write("| MIN | ");
        for (int j = 0; j < vardaGarums; j++)
            Console.Write($"{columnMins[j],-4}| ");
        Console.WriteLine($"*    | {kopejalMin,-4}| *    |");

        // atdala rindas
        Console.Write("*");
        for (int j = 0; j < vardaGarums + 4; j++)
            Console.Write("====*");
        Console.WriteLine("====*====*====*");

        // MAX rinda
        Console.Write("| MAX | ");
        for (int j = 0; j < vardaGarums; j++)
            Console.Write($"{columnMaxs[j],-4}| ");
        Console.WriteLine($"*    | *    | {kopejalMax,-4}|");

        // Tabulas apakšējā līnija
        Console.Write("*");
        for (int j = 0; j < vardaGarums + 4; j++)
            Console.Write("====*");
        Console.WriteLine("====*====*====*");
    }
}
