using System;
using System.Collections.Generic;


// Klase pārstāv vienu failu vai mapi
class failussistema
{
    public string Nosaukums; // Objekta vards
    public failussistema Vecaks;// Norāde uz vecaku mapi
    public List<failussistema> Berni;// List ar berniem 
    public string Tips;// Tips: "mape" vai "datne"

    
    public failussistema(string nosaukums, string tips, failussistema vecaks)
    {
        Nosaukums = nosaukums;
        Tips = tips;
        Vecaks = vecaks;
        if (tips == "mape") Berni = new List<failussistema>();
    }

    // Parāda mapes saturu vai faila tipu
    public void Paradit()
    {
        if (Tips == "datne")
        {
            Console.WriteLine("/~" + Nosaukums + "~");
        }
        else if (Tips == "mape")
        {
            Console.WriteLine("/[" + Nosaukums + "]");
            foreach (var berns in Berni)
            {
                if (berns.Tips == "mape")
                    Console.WriteLine("  [M] " + berns.Nosaukums);
                else
                    Console.WriteLine("  [D] " + berns.Nosaukums);
            }
        }
    }

    // Meklē bērnu objektu pēc nosaukuma
    public failussistema AtrastBerni(string nosaukums)
    {
        if (Tips == "datne") return null;
        foreach (var berns in Berni)
        {
            if (berns.Nosaukums.Equals(nosaukums, StringComparison.OrdinalIgnoreCase)) // parbauda vai Nosaukums = nosaukums un ignore mazos un lielos burtus
                return berns;
        }
        return null;
    }

    // Dzēš bērnu no saraksta
    public void DzestBerni(failussistema berns)
    {
        if (Tips == "mape")
            Berni.Remove(berns);
    }
}

// Galvenā programma
class Program
{
    static failussistema sakne;     // Saknes mape (piemēram, c:)
    static failussistema atrasanas; // Norāde uz pašreizējo atrašanās vietu

    static void Main()
    {
        // Inicializē saknes mapi
        sakne = new failussistema("c:", "mape", null);
        atrasanas = sakne;

        // Galvena komanda
        while (true)
        {
            try
            {
                Console.Write(GetPilnaAtrasanasVieta() + ">");
                string ievade = Console.ReadLine();
                if (string.IsNullOrEmpty(ievade)) continue;

                string[] komandas = ievade.Split(' ', StringSplitOptions.RemoveEmptyEntries);// sadala vardus un nonem tuksumus
                string pavele = komandas[0].ToLower();

                if (pavele == "exit" || pavele == "by")
                    break;

                switch (pavele)
                {
                    case "mkdir":
                        for (int i = 1; i < komandas.Length && i <= 3; i++)
                            IzveidotMapi(komandas[i]);
                        break;

                    case "create":
                        for (int i = 1; i < komandas.Length && i <= 3; i++)
                            IzveidotDatni(komandas[i]);
                        break;

                    case "dir":

                        
                        if (komandas.Length == 1)
                            atrasanas.Paradit(); // Parāda pašreizējās mapes bērnus (gan mapes, gan datnes)

                        // Ja komanda ir "dir >nosaukums" — tas nozīmē, ka saturu grib ierakstīt datnē
                        else if (komandas.Length == 2 && komandas[1].StartsWith(">"))
                            IzvaditDirDatne(komandas[1].Substring(1));
                        break; 


                    case "cd":
                        if (komandas.Length == 2)
                            Parvietoties(komandas[1]);
                        break;

                    case "rm":
                        for (int i = 1; i < komandas.Length; i++)
                            DzestMapi(komandas[i]);
                        break;

                    case "del":
                        for (int i = 1; i < komandas.Length; i++)
                            DzestDatni(komandas[i]);
                        break;

                    case "edit":
                        if (komandas.Length == 2)
                            RedigetDatni(komandas[1]);
                        break;

                    default:
                        Console.WriteLine("Nezināma komanda!");
                        break;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Kļūda: " + ex.Message);
            }
        }
    }

    // Atgriež pilnu ceļu uz pašreizējo vietu
    
    static string GetPilnaAtrasanasVieta()
    {
        
        List<string> cels = new List<string>();

        // Sāk ar pašreizējo atrašanās vietu
        failussistema temp = atrasanas;

        // Cikls, kas iet cauri visām mapei līdz saknei
        while (temp != null)
        {
            // Ievieto katras mapes nosaukumu saraksta sākumā,
            cels.Insert(0, temp.Nosaukums);
            // Pāriet uz vecāku (augstāk esošu) mapi
            temp = temp.Vecaks;
        }
        // Apvieno visus mapju nosaukumus ar / un pievieno / beigās
        return string.Join("/", cels) + "/";
    }

            

        


    // Izveido jaunu mapi
    static void IzveidotMapi(string nosaukums)
    {
        if (atrasanas.AtrastBerni(nosaukums) == null)
        {
            var jaunaMape = new failussistema(nosaukums, "mape", atrasanas);
            atrasanas.Berni.Add(jaunaMape);
        }
        else
        {
            Console.WriteLine("Kļūda: Tāds vārds jau eksistē!");
        }
    }

    // Izveido jaunu failu
    static void IzveidotDatni(string nosaukums)
    {
        if (atrasanas.AtrastBerni(nosaukums) == null)
        {
            var jaunaDatne = new failussistema(nosaukums, "datne", atrasanas);
            atrasanas.Berni.Add(jaunaDatne);
             
        }
        else
        {
            Console.WriteLine("Kļūda: Tāds vārds jau eksistē!");
        }
    }

    // Izvada dir  saturu uz teksta failu
    
    static void IzvaditDirDatne(string datnesNosaukums)
    {
       
        string fails = datnesNosaukums + ".txt";

        // Ja datne jau eksistē, tad to izdzēš
        if (File.Exists(fails))
            File.Delete(fails);

        // Izveido jaunu teksta datni un ieraksta tajā katru bērnu pašreizējā mapē
        using (StreamWriter sw = new StreamWriter(fails))
        {
           
            foreach (var berns in atrasanas.Berni)
            {
                // Ieraksta rindu ar tipu (MAPE/DATNE) un nosaukumu
                sw.WriteLine(berns.Tips.ToUpper() + " " + berns.Nosaukums);
            }
        }
                

        // Ja objekts ar šādu nosaukumu vēl neeksistē failu sistēmas struktūrā
        if (atrasanas.AtrastBerni(datnesNosaukums) == null)
        {
            // Tad izveido jaunu datni kā objektu sistēmā (virtuāli)
            var jaunaDatne = new failussistema(datnesNosaukums, "datne", atrasanas);

            // Un pievieno to pašreizējai mapei kā bērnu
            atrasanas.Berni.Add(jaunaDatne);
        }
    }


    // Pārvietojas uz citu mapi
    static void Parvietoties(string nosaukums)
    {
        // Ja komanda ir "cd ..", pārvietojas uz vecāku mapi (ja tāda ir)
        if (nosaukums == "..")
        {
            if (atrasanas.Vecaks != null)
                atrasanas = atrasanas.Vecaks;
        }
        // Ja komanda ir "cd /", pārvietojas uz sakni ("c:")
        else if (nosaukums == "/")
        {
            atrasanas = sakne;
        }
        // Citādi mēģina pārvietoties uz apakšmapi ar norādīto nosaukumu
        else
        {
            var mape = atrasanas.AtrastBerni(nosaukums); // Meklē bērnu ar šo nosaukumu
            if (mape != null && mape.Tips == "mape")
                atrasanas = mape; // Ja atrasta mape, pārvietojas tajā
            else
                Console.WriteLine("Mape nav atrasta!");// Ja nav, izvada kļūdu
        }
    }

    // Dzēš mapi (ar apstiprinājumu ja ir bērni)
    
    static void DzestMapi(string nosaukums)
    {
        // Mēģina atrast mapi ar norādīto nosaukumu pašreizējā mapē
        var mape = atrasanas.AtrastBerni(nosaukums);

        // Ja mape tiek atrasta un tās tips ir "mape"
        if (mape != null && mape.Tips == "mape")
        {
            // Ja mapei ir bērni, jautā lietotājam, vai tiešām vēlas to dzēst
            if (mape.Berni.Count > 0)
            {
                Console.Write($"Mapei '{nosaukums}' ir bērni. Vai tiešām dzēst? (y/n): ");
                if (Console.ReadLine().ToLower() != "y") 
                    return;
            }
            // Ja lietotājs apstiprina, tad dzēš šo mapi no pašreizējās mapes bērniem
            atrasanas.DzestBerni(mape);
            Console.WriteLine($"Mape '{nosaukums}' dzēsta.");
        }
        else
        {
            // Ja mape nav atrasta, izvada kļūdas ziņojumu
            Console.WriteLine("Mape nav atrasta!");
        }
    }

               
    // Dzēš failu gan sistēmā, gan fiziski uz diska
    static void DzestDatni(string nosaukums)
    {
        var datne = atrasanas.AtrastBerni(nosaukums);// megina atrast datni
        if (datne != null && datne.Tips == "datne") // ja atrod datni un tips ir datne
        {
            atrasanas.DzestBerni(datne);
            string fails = nosaukums;
            if (File.Exists(fails)) // ja fails eksiste to izdzes
            {
                Console.WriteLine($"Datne '{nosaukums}' dzēsta.");
            }
        }
        else
        {
            Console.WriteLine("Datne nav atrasta!");
        }
    }

    // Parāda datnes saturu
    static void RedigetDatni(string nosaukums)
    {
        string fails = nosaukums;
        if (File.Exists(fails))// parbauda vai fails eksiste
        {
            Console.WriteLine($"Saturs failā {nosaukums}:");
            Console.WriteLine(File.ReadAllText(fails));//izlasa faila saturu un to parada
        }
        else
        {
            Console.WriteLine("Datne neeksistē uz diska!");
        }
    }
}
// Avoti:https://learn.microsoft.com/en-us/dotnet/api/system.io?view=net-9.0 ,w3schools,stackoverflow,chatgpt,geeksforgeeks.






