using System;
using System.Linq;

class Program
{
    static void Main()
    {
        //  ievada teikumu
        Console.WriteLine("ievadi teikumu:");
        string input;
        var linijas = new System.Collections.Generic.List<string>();

        // Ievadīt tekstu 
        while (!string.IsNullOrWhiteSpace(input = Console.ReadLine()))
        {
            linijas.Add(input); // Pievieno katru ievadīto rindu sarakstam
        }

        // parada tekstu ar apgrieztiem vārdiem
        Console.WriteLine("Samainīti vārdi");
        linijas.Reverse(); 
        Console.WriteLine(string.Join(" ", linijas.SelectMany(line => line.Split(' ')).Reverse())); 

        // parada tekstu ar apgrieztiem burtiem 
        Console.WriteLine("Samainīti burti vārdos");
        foreach (var line in linijas)
        {
            Console.WriteLine(string.Join(" ", line.Split(' ').Select(word => new string(word.Reverse().ToArray())))); 
        }

        // Savieno visus teikumus 
        string pilnsTeksts = string.Join(" ", linijas);
        int vidus = pilnsTeksts.Length / 2; 
        int garums = pilnsTeksts.Length; 

        // for cikls lai dabutu tekstu centra
        for (int i = 0; i <= vidus; i++)
        {
            int start = Math.Max(0, vidus - i);  
            int garums2 = Math.Min(pilnsTeksts.Length - start, 2 * i + 1);  
            string substring = pilnsTeksts.Substring(start, garums2); 

           
            int padding = (garums - substring.Length) / 2;

           
            Console.WriteLine(substring.PadLeft(substring.Length + padding)); 
        }

        // teksts kas pzud no vidus
        for (int i = 0; i <= vidus; i++)
        {
            char[] teksts = pilnsTeksts.ToCharArray();
            for (int j = 0; j < i; j++)
            {
                if (vidus - j >= 0) teksts[vidus - j] = ' '; 
                if (vidus + j < teksts.Length) teksts[vidus + j] = ' '; 
            }
            Console.WriteLine(new string(teksts)); 
        }

        // Izdrukā tekstu, sākot no viena  burta lidz visam tekstam
        for (int i = 1; i <= pilnsTeksts.Length; i++)
        {
            Console.WriteLine(pilnsTeksts.Substring(pilnsTeksts.Length - i).PadLeft(pilnsTeksts.Length)); 
        }

        // Izdrukā tekstu, noņemot vienu simbolu no labās puses katrā rindā
        for (int i = 1; i < pilnsTeksts.Length; i++)
        {
            Console.WriteLine(pilnsTeksts.Substring(0, pilnsTeksts.Length - i)); 
        }
    }
}
