// Pieprasām lietotājam ievadīt vārdu un to nolasām
Console.Write("Ievadi vārdu: ");
string name = Console.ReadLine();

// Pieprasām lietotājam ievadīt uzvārdu un to nolasām
Console.Write("Ievadi uzvārdu: ");
string surname = Console.ReadLine();

// Izsaucam TabulasDati funkciju, lai iegūtu 2D masīvu ar gadījuma skaitļiem
int[,] data = TabulasDati(name, surname);

// Izdrukājam tabulas galvu, izmantojot vārdu
TabulasGalva(name);

// Izdrukājam sākotnējo tabulu
Tabula(data);

// Izdrukājam atstarpes starp tabulām
Console.WriteLine("\n\n\n");

// Izsaucam funkciju, kas apmaina rindas ar kolonnām
int[,] revData = TabulasMaina(data);

// Izdrukājam tabulas galvu transformētai tabulai, izmantojot uzvārdu
TabulasGalva(surname);

// Izdrukājam transformēto tabulu
Tabula(revData);

// Metode, kas izveido tabulas līniju ar noteiktu svītriņu skaitu un atkārtojumu skaitu
static void TabulasLinija(int lineAmount, int amount)
{
    // Cikls, kas atkārto zvaigznītes un svītriņas noteiktu reižu skaitu
    for (int i = 0; i < amount; i++)
    {
        // Izdrukājam zvaigznīti
        Console.Write("*");

        // Cikls, kas izdrukā svītriņas starp zvaigznītēm
        for (int j = 0; j < lineAmount; j++)
        {
            Console.Write("-");
        }
    }

    // Izdrukājam pēdējo zvaigznīti un pārejam uz jaunu rindu
    Console.WriteLine("*");
}

// Metode, kas izveido tabulas rindu ar datiem un to statistiku
static void TabulasRinda(int[] rowData, int max, int min, int sum)
{
    // Cikls, kas izdrukā katru skaitli no rindas datiem
    for (int i = 0; i < rowData.Length; i++)
    {
        // Ja skaitlis ir mazāks par 10, formatējam to ar papildu atstarpi
        if (rowData[i] < 10)
        {
            Console.Write($"|  {rowData[i]}  ");
        }
        else
        {
            // Ja skaitlis ir lielāks par 9, formatējam ar mazāk atstarpēm
            Console.Write($"|  {rowData[i]} ");
        }
    }

    // Formatējam un izdrukājam maksimālo vērtību atkarībā no tās lieluma
    if (max < 10)
        Console.Write($"|  {max}  ");
    else
        Console.Write($"|  {max} ");

    // Formatējam un izdrukājam minimālo vērtību atkarībā no tās lieluma
    if (min < 10)
        Console.Write($"|  {min}  ");
    else
        Console.Write($"|  {min} ");

    // Formatējam un izdrukājam summas vērtību atkarībā no tās lieluma
    if (sum < 10)
        Console.Write($"|  {sum}  ");
    else if (sum > 99)
        Console.Write($"| {sum} ");
    else
        Console.Write($"|  {sum} ");

    // Izdrukājam pēdējo vertikālo līniju un pārejam uz jaunu rindu
    Console.WriteLine("|");
}

// Funkcija, kas ģenerē 2D masīvu ar gadījuma skaitļiem
static int[,] TabulasDati(string name, string surname)
{
    // Inicializējam gadījuma skaitļu ģeneratoru
    Random rnd = new Random();

    // Nosakām minimālo vērtību kā vārda garumu
    int minValue = name.Length;

    // Nosakām maksimālo vērtību kā uzvārda garumu
    int maxValue = surname.Length;

    // Izveidojam 2D masīvu ar izmēru, kas atbilst uzvārda garumam un vārda garumam
    int[,] data = new int[maxValue, minValue];

    // Aizpildām masīvu ar gadījuma skaitļiem
    for (int i = 0; i < maxValue; i++)
    {
        for (int j = 0; j < minValue; j++)
        {
            // Ģenerējam gadījuma skaitli no vārda garuma līdz vārda+uzvārda garumam
            data[i, j] = rnd.Next(minValue, minValue + maxValue);
        }
    }

    // Atgriežam aizpildīto masīvu
    return data;
}

// Metode, kas izveido tabulas galvu
static void TabulasGalva(string name)
{
    // Izdrukājam tabulas augšējo līniju
    TabulasLinija(5, name.Length + 3);

    // Izdrukājam vārda burtus kā kolonnu nosaukumus
    for (int i = 0; i < name.Length; i++)
    {
        Console.Write($"|  {name.Substring(i, 1)}  ");
    }

    // Izdrukājam statistikas kolonnu nosaukumus
    Console.Write($"| max ");
    Console.Write($"| min ");
    Console.Write($"| sum ");
    Console.WriteLine("|");
}

// Metode, kas izdrukā visu tabulu
static void Tabula(int[,] data)
{
    // Iegūstam rindu skaitu no masīva
    int rowLength = data.GetLength(0);

    // Izveidojam 1D masīvu rindu datiem
    int[] rowData = new int[data.GetLength(1)];

    // Apstrādājam katru rindu
    for (int i = 0; i < rowLength; i++)
    {
        // Iegūstam datus no 2D masīva rindas
        for (int j = 0; j < data.GetLength(1); j++)
        {
            rowData[j] = data[i, j];
        }

        // Aprēķinām statistiku - maksimālo vērtību, minimālo vērtību un summu
        int max = rowData.Max();
        int min = rowData.Min();
        int sum = rowData.Sum();

        // Izdrukājam līniju virs rindas datiem
        TabulasLinija(5, rowData.Length + 3);

        // Izdrukājam rindu ar datiem un statistiku
        TabulasRinda(rowData, max, min, sum);
    }

    // Izdrukājam tabulas apakšējo līniju
    TabulasLinija(5, rowData.Length + 3);
}

// Funkcija, kas apmaina rindas ar kolonnām
static int[,] TabulasMaina(int[,] data)
{
    // Iegūstam sākotnējā masīva rindu un kolonnu skaitu
    int rowLength = data.GetLength(0);
    int colLenght = data.GetLength(1);

    // Izveidojam jaunu masīvu ar samainītiem izmēriem
    int[,] revData = new int[colLenght, rowLength];

    // Veicam masīva transponēšanu - apmainām rindas ar kolonnām
    for (int i = 0; i < rowLength; i++)
    {
        for (int j = 0; j < colLenght; j++)
        {
            revData[j, i] = data[i, j];
        }
    }

    // Atgriežam transponēto masīvu
    return revData;
}