using System;
using System.Data.SqlTypes;
using System.Linq;
using static System.Runtime.InteropServices.JavaScript.JSType;

class Program
{
    // Galvenā funkcija, kur programma sākas
    static void Main(string[] args)
    {
        // Ievada lietotāja vārdu un uzvārdu
        Console.Write("Ievadiet savu vārdu: ");
        string name = Console.ReadLine();  // Saglabā vārdu
        Console.Write("Ievadiet savu uzvārdu: ");
        string surname = Console.ReadLine();  // Saglabā uzvārdu

        // Apgriež uzvārdu
        surname = new string(surname.Reverse().ToArray());

        // Pārvērš abus vārdus maziem burtiem
        name = name.ToLower();
        surname = surname.ToLower();

        // Izveido bolder līnijas un parāda vārdu un uzvārdu
        createBoldLines(name);
        nameSurnameCorrect(name, surname);
        Console.WriteLine();

        // Maina vietām vārdu un uzvārdu
        string tempName = surname;
        string tempSurname = name;

        name = tempName;
        surname = tempSurname;

        // Izveido bolder līnijas un parāda vārdu un uzvārdu pēc maiņas
        createBoldLines(name);
        nameSurnameCorrect(name, surname);
    }

    // Funkcija, kas izveido bolder līnijas ar zvaigznītēm
    static void createBoldLines(string name)
    {
        for (int i = 0; i < name.Length + 4; i++)
        {
            Console.Write("*=======");  // Izdrukā zvaigznītes
        }
        Console.WriteLine("*");
    }

    // Funkcija, kas koriģē vārda un uzvārda rakstību
    static void nameSurnameCorrect(string name, string surname)
    {
        string correctName = "";
        string correctSurname = "";

        // Koriģē vārda lielos un mazos burtus
        for (int i = 0; i < name.Length; i++)
        {
            if (i < name.Length)
            {
                string Upper = name.Substring(i, 1).ToUpper();
                correctName += Upper;
                i++;
            }
            if (i < name.Length)
            {
                string Lower = name.Substring(i, 1).ToLower();
                correctName += Lower;
            }
        }

        // Koriģē uzvārda lielos un mazos burtus
        for (int i = 0; i < surname.Length; i++)
        {
            if (i < surname.Length)
            {
                string Upper = surname.Substring(i, 1).ToLower();
                correctSurname += Upper;
                i++;
            }
            if (i < surname.Length)
            {
                string Lower = surname.Substring(i, 1).ToUpper();
                correctSurname += Lower;
            }
        }

        // Izveido pirmo līniju un izdrukā uzvārdu
        firstLine(correctName);
        surnameLine(correctSurname, correctName);
    }

    // Funkcija, kas izveido pirmo līniju ar vārdu
    static string firstLine(string name)
    {
        string line1 = $"X{name}";
        for (int i = 0; i <= name.Length; i++)
        {
            string letter = line1.Substring(i, 1);
            Console.Write($"|   {letter}   ");
        }
        Console.WriteLine("|  sum  |  min  |  max  |");
        createBoldLines(name);
        return name;
    }

    // Funkcija, kas izdrukā uzvārdu ar numuriem un aprēķina summu, minimālo un maksimālo vērtību
    static void surnameLine(string surname, string name)
    {
        Random rnd = new Random();  // Izveido nejaušības ģeneratoru
        int[,] numbers = new int[surname.Length, name.Length];  // Masīvs numuriem
        int sumOfSums = 0;
        int minOfMin = surname.Length + name.Length;
        int maxOfMax = 0;

        // Aizpilda masīvu ar nejaušiem skaitļiem
        for (int i = 0; i < surname.Length; i++)
        {
            for (int j = 0; j < name.Length; j++)
            {
                numbers[i, j] = rnd.Next(name.Length, name.Length + surname.Length + 1);
            }
        }

        string space = " ";
        string minString = "";
        string maxString = "";

        // Izdrukā katru rindu ar uzvārdu un numuriem
        for (int i = 0; i < surname.Length; i++)
        {
            int min = surname.Length + name.Length;
            int max = 0;
            int sum = 0;
            string sumString = "";
            string letter = surname.Substring(i, 1);
            Console.Write($"|   {letter}   ");
            for (int j = 0; j < name.Length; j++)
            {
                int number = numbers[i, j];
                string numberString = number.ToString();
                if (numberString.Length == 1)
                    space = "   ";
                else if (numberString.Length == 2)
                    space = "  ";
                else
                    space = " ";
                Console.Write($"|   {number}{space}");  // Izdrukā numuru

                // Aprēķina minimālo un maksimālo vērtību, kā arī summu
                if (number < min)
                {
                    min = number;
                    minOfMin = number;
                }
                if (number > max)
                    max = number;
                sum += number;

                // Koriģē minimālo, maksimālo un summas vērtības formātu
                minString = $"   {min}   ";
                bool isMinTrue = true;
                do
                {
                    if (minString.Length > 7)
                        minString = minString.Substring(0, 7);
                    else
                        isMinTrue = false;
                }
                while (isMinTrue);

                maxString = $"   {max}   ";
                bool isMaxTrue = true;
                do
                {
                    if (maxString.Length > 7)
                        maxString = maxString.Substring(0, 7);
                    else
                        isMaxTrue = false;
                }
                while (isMaxTrue);

                sumString = $"   {sum} ";
                if (sum <= 99)
                    sumString += " ";
                bool isSumTrue = true;
                do
                {
                    if (sumString.Length - 1 > 7)
                        sumString.Substring(sumString.Length, 1);
                    else
                        isSumTrue = false;
                }
                while (isSumTrue);

            }
            sumOfSums += sum;

            Console.WriteLine($"|{sumString}|{minString}|{maxString}|");  // Izdrukā rezultātus
            if (i < surname.Length - 1)
                skinnyLines(name.Length);  // Izveido plānās līnijas starp rindām
            else
                createBoldLines(name);  // Izveido bolder līnijas

        }

        // Izdrukā summu, minimālo un maksimālo vērtību visām kolonnām
        Console.Write("|  sum  ");
        for (int i = 0; i < name.Length; i++)
        {
            int sum = 0;
            for (int j = 1; j < surname.Length; j++)
            {
                sum += numbers[j, i];
                string numberString = sum.ToString();
                if (numberString.Length == 1)
                    space = "   ";
                else if (numberString.Length == 2)
                    space = "  ";
                else
                    space = " ";
            }
            sumOfSums += sum;
            Console.Write($"|   {sum}{space}");  // Izdrukā summu katrai kolonnai
        }
        if (sumOfSums > 999)
            space = " ";
        if (sumOfSums <= 999)
            space = "  ";
        Console.WriteLine($"|  {sumOfSums}{space}|   *   |   *   |");
        createBoldLines(name);

        // Izdrukā minimālo vērtību katrai kolonnai
        Console.Write("|  min  ");
        for (int i = 0; i < name.Length; i++)
        {
            int min = surname.Length + 6;
            int number = 0;
            for (int j = 1; j < surname.Length; j++)
            {
                number = numbers[j, i];
                if (min > number)
                    min = number;
            }

            minString = $"   {min}   ";
            bool isMinTrue = true;
            do
            {
                if (minString.Length > 7)
                {
                    minString = minString.Substring(0, 7);  // Koriģē min vērtību garumu
                }
                else
                    isMinTrue = false;
            }
            while (isMinTrue);
            Console.Write($"|{minString}");  // Izdrukā minimālo vērtību
        }
        Console.WriteLine($"|   *   |{minString}|   *   |");

        createBoldLines(name);

        // Izdrukā maksimālo vērtību katrai kolonnai
        Console.Write("|  max  ");
        for (int i = 0; i < name.Length; i++)
        {
            int max = 0;
            int number = 0;
            for (int j = 1; j < surname.Length; j++)
            {
                number = numbers[j, i];
                if (max < number)
                    max = number;
            }

            maxString = $"   {max}   ";
            bool isMaxTrue = true;
            do
            {
                if (maxString.Length > 7)
                    maxString = maxString.Substring(0, 7);  // Koriģē max vērtību garumu
                else
                    isMaxTrue = false;
            }
            while (isMaxTrue);
            Console.Write($"|{maxString}");  // Izdrukā maksimālo vērtību
        }
        Console.WriteLine($"|   *   |   *   |{maxString}|");

        createBoldLines(name);
    }

    // Funkcija, kas izveido plānas līnijas starp tabulas rindām
    static void skinnyLines(int length)
    {
        for (int i = 0; i < length + 1; i++)
        {
            Console.Write("+-------");  // Izdrukā plānas līnijas
        }
        Console.WriteLine("*=======*=======*=======*");
    }
}
