class Bankaskonts
{
    public int KontaNumurs;
    public string Vards;
    public decimal Atlikums;

    public int nakamaisKontaNr = 1;

    public Bankaskonts(string vards, decimal atlikums)
    {
        KontaNumurs = nakamaisKontaNr++;
        Vards = vards;
        Atlikums = atlikums;
    }

    public void iemaksat(decimal summa)
    {
        if (summa <= 0)
        {
            Console.WriteLine("Iemaksai jabut pozitivai");
        }
        else
        {
            Atlikums += summa;
        }
    }

    public void iznemt(decimal summa)
    {
        if(summa>Atlikums)
        {
            Console.WriteLine("Jus nevarat iznemt tik daudz");
        }
        else
        {
            Atlikums -= summa;
        }

    }


    public void paraditinfo()
    {
        Console.WriteLine($"Konta numurs{KontaNumurs} ipasnieks {Vards} nauda {Atlikums}");
    }
    ~Bankaskonts()
    {
        Console.WriteLine($"Konts Nr {KontaNumurs} tika izdzēsts.");
    }
}


class Program
{
    static List<Bankaskonts> konti = new List<Bankaskonts>();

    static void Main()
    {
        while (true)
        {
            Console.WriteLine();
            Console.WriteLine("Izvelieties darbibu");

            Console.WriteLine("1. izveidot jaunu kontu");
            Console.WriteLine("2. Noguldit naudu konta");
            Console.WriteLine("3. Iznemt naudu no konta");
            Console.WriteLine("4. Paradit konta informaciju");
            Console.WriteLine("5. Dzest kontu");
            Console.WriteLine("6. Iziet no sistemas");
            
            int izvele = Convert.ToInt32(Console.ReadLine());

            if (izvele == 1)
            {
                IzveidotKontu();
            } else if (izvele == 2)
            {
                NaudasIemaksa();
            } else if (izvele == 3)
            {
                NaudasIzmaksa();
            } else if (izvele == 4)
            {
                RādītInformāciju();
            } else if (izvele == 5)
            {
                DzēstKontu();
            } else if(izvele == 6)
            {
                return;
            }else
            {
                Console.WriteLine("Nederiga izvele");
            }


            static Bankaskonts AtrastKontu()
            {
                Console.Write("Ievadi konta numuru: ");
                int nr = int.Parse(Console.ReadLine());
                var konts = konti.Find(k => k.KontaNumurs == nr);
                if (konts == null)
                    throw new Exception("Konts nav atrasts.");
                return konts;
            }

            static void IzveidotKontu()
            {
                Console.Write("Ievadi īpašnieka vārdu: ");
                string vārds = Console.ReadLine();
                Console.Write("Ievadi sākuma atlikumu: ");
                decimal sākums = decimal.Parse(Console.ReadLine());

                var konts = new Bankaskonts(vārds, sākums);
                konti.Add(konts);
                Console.WriteLine("Konts veiksmīgi izveidots.");
            }

            static void NaudasIemaksa()
            {
                var konts = AtrastKontu();
                Console.Write("Ievadi iemaksājamo summu: ");
                decimal summa = decimal.Parse(Console.ReadLine());
                konts.iemaksat(summa);
                Console.WriteLine("Iemaksa veiksmīga.");
            }

            static void NaudasIzmaksa()
            {
                var konts = AtrastKontu();
                Console.Write("Ievadi izņemamo summu: ");
                decimal summa = decimal.Parse(Console.ReadLine());
                konts.iznemt(summa);
                Console.WriteLine("Izmaksa veiksmīga.");
            }

            static void RādītInformāciju()
            {
                var konts = AtrastKontu();
                konts.paraditinfo();
            }

            static void DzēstKontu()
            {
                var konts = AtrastKontu();
                konti.Remove(konts);
                Console.WriteLine("Konts izdzēsts no saraksta.");
            }
        }
    }
}
