using System;
using System.Globalization;

// Lietotājs ievada savu vārdu
Console.Write("Ievadi vārdu: ");
string firstName = Console.ReadLine().Trim();

// Lietotājs ievada savu uzvārdu
Console.Write("Ievadi uzvārdu: ");
string lastName = Console.ReadLine().Trim();

// Pārvērš ievadīto vārdu un uzvārdu tā, lai tie sāktos ar lielo burtu
firstName = CapitalizeFirstLetter(firstName);
lastName = CapitalizeFirstLetter(lastName);

// Aprēķina vārda un uzvārda simbolu skaitu
int firstNameLength = firstName.Length;
int lastNameLength = lastName.Length;
int totalLength = firstNameLength + lastNameLength;

// Izveido nejaušu skaitļu ģeneratoru
Random random = new Random();

// Izvada formatētu tekstu par lietotāja vārdu un uzvārdu
Console.WriteLine($"Mans vārds ir {firstName} un tajā ir {firstNameLength} simboli");
Console.WriteLine($"Mans uzvārds ir {lastName} un tajā ir {lastNameLength} simboli");

// Funkcija, lai izdrukātu līniju ar "+" starp katru kolonnu
void PrintLine(int columnCount)
{
    for (int i = 0; i < columnCount; i++)
    {
        Console.Write("+-----");
    }
    Console.WriteLine("+");
}

// Aprēķina kopējo kolonnu skaitu tabulai (X + burti + MAX/MIN/AVG/SUM)
int totalColumns = firstNameLength + 5;

// Izdrukā tabulas augšējo robežu
PrintLine(totalColumns);

// Izdrukā pirmo rindu ar lietotāja vārda burtiem
Console.Write("|  X  ");
foreach (char c in firstName.ToUpper())
    Console.Write($"|  {c}  ");
Console.WriteLine("| MAX | MIN | AVG | SUM |");

// Izdrukā atdalīšanas līniju pēc pirmās rindas
PrintLine(totalColumns);

// Cikls, kas izveido un izdrukā nejaušos skaitļus katrai uzvārda burtu rindai
for (int i = 0; i < lastNameLength; i++)
{
    Console.Write($"|  {lastName[i]}  ");
    int[] randomNumbers = new int[firstNameLength];
    int max = int.MinValue, min = int.MaxValue, sum = 0;

    // Ģenerē nejaušus skaitļus un aprēķina maksimālo, minimālo, vidējo un summu
    for (int j = 0; j < firstNameLength; j++)
    {
        randomNumbers[j] = random.Next(firstNameLength, totalLength + 1);
        sum += randomNumbers[j];
        if (randomNumbers[j] > max) max = randomNumbers[j];
        if (randomNumbers[j] < min) min = randomNumbers[j];
        Console.Write($"| {randomNumbers[j],3} ");
    }

    // Aprēķina vidējo vērtību un izdrukā visu rindu
    double avg = Math.Round(sum / (double)firstNameLength, 1);
    Console.WriteLine($"| {max,3} | {min,3} | {avg,3} | {sum,3} |");

    // Ja tā nav pēdējā rinda, izdrukā līniju starp rindām
    if (i < lastNameLength - 1)
    {
        PrintLine(totalColumns);
    }
}

// Izdrukā tabulas apakšējo robežu
PrintLine(totalColumns);

// Funkcija, kas nodrošina, ka katrs vārds sākas ar lielo burtu
static string CapitalizeFirstLetter(string text)
{
    if (string.IsNullOrWhiteSpace(text))
        return string.Empty;

    return CultureInfo.CurrentCulture.TextInfo.ToTitleCase(text.ToLower());
}
