using System;
using System.Linq;


// Lūdz ievadīt teikumu
Console.Write("Ievadi teikumu: ");
string input;
var lines = new System.Collections.Generic.List<string>();

// Kamēr lietotājs ievada teikumus, pievieno katru rindu sarakstam
while (!string.IsNullOrWhiteSpace(input = Console.ReadLine()))
    lines.Add(input); // Pievieno katru ievadīto teikumu

// Izdrukā tekstu ar apgrieztiem vārdiem
Console.WriteLine("Samainīti vārdi:");
lines.Reverse(); // Pagriež sarakstu, lai vārdi būtu apgriezti
Console.WriteLine(string.Join(" ", lines.SelectMany(line => line.Split(' ')).Reverse())); // Apgriež arī vārdus

// Izdrukā tekstu ar apgrieztiem burtiem katrā vārdā
Console.WriteLine("Samainīti burti vārdos:");
foreach (var line in lines)
    // Apgriež katra vārda burtus
    Console.WriteLine(string.Join(" ", line.Split(' ').Select(word => new string(word.Reverse().ToArray()))));

// Savieno visus ievadītos teikumus vienā lielā tekstā
string fullText = string.Join(" ", lines);
int middle = fullText.Length / 2; // Nosaka teksta viduspunktu
int length = fullText.Length;

// Drukā tekstu, izveidojot piramīdu no teksta centra
for (int i = 0; i <= middle; i++)
{
    int start = Math.Max(0, middle - i); // Nosaka, no kuras pozīcijas ņemt apakšvirsrakstu
    int width = Math.Min(fullText.Length - start, 2 * i + 1); // Nosaka, cik daudz burtu jāiekļauj rindā
    string substring = fullText.Substring(start, width); // Ņem apakšvirsrakstu

    int padding = (length - substring.Length) / 2; // Aprēķina atstarpi, lai centrs būtu vidū
    Console.WriteLine(substring.PadLeft(substring.Length + padding)); // Drukā izveidoto tekstu ar atstarpi
}

// Drukā tekstu, pamazām aizpildot to no vidus līdz malām
for (int i = 0; i <= middle; i++)
{
    char[] textArray = fullText.ToCharArray(); // Pārvērš tekstu masīvā
    for (int j = 0; j < i; j++)
    {
        if (middle - j >= 0) textArray[middle - j] = ' '; // Aizvieto burtus ar atstarpēm kreisajā pusē
        if (middle + j < textArray.Length) textArray[middle + j] = ' '; // Aizvieto burtus ar atstarpēm labajā pusē
    }
    Console.WriteLine(new string(textArray)); // Drukā tekstu ar atstarpēm
}

// Drukā tekstu, sākot no viena burta līdz pilnam tekstam
for (int i = 1; i <= fullText.Length; i++)
    Console.WriteLine(fullText.Substring(fullText.Length - i).PadLeft(fullText.Length)); // Drukā katru nākamo burtu

// Drukā tekstu, noņemot vienu simbolu no labās puses katrā rindā
for (int i = 1; i < fullText.Length; i++)
    Console.WriteLine(fullText.Substring(0, fullText.Length - i)); // Noņem vienu simbolu no labās puses
    