<!-- BMD: HTML dokumenta sākums -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8"> <!-- Norāda rakstzīmju kodējumu -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <!-- Padara lapu pielāgojamu mobilajām ierīcēm -->
    <title>Document</title> <!-- Lapas virsraksts -->

    <style>
        /* BMD: Stilu sadaļa */

        /* Formas stils */
        #form {
            margin: 20px;
            padding: 5px;
            border: 5px solid black;
            width: 300px;
        }

        /* Teksta padarīšana treknrakstā */
        #bold {
            font-weight: bold;
        }

        /* Tabulas pamatstils */
        table {
            border-collapse: collapse;
            border: 4px solid rgb(140 140 140);
            font-family: sans-serif;
            font-size: 0.8rem;
            letter-spacing: 1px;
        }

        /* Tabulas šūnu (th un td) stils */
        th,
        td {
            border: 1px solid rgb(160 160 160);
            padding: 8px 10px;
        }
        /* BMD: Stilu sadaļa beidzas */
    </style>
</head>
<body>
   
    <!-- BMD: Forma datu ievadei -->
    <form action="save.php" id="form" name="form">
        <fieldset> <!-- Grupē personas datu ievades laukus -->
            <legend id="bold">Personas dati</legend><br>
        
            <!-- Slēpts lauks ID vērtībai -->
            <label name="id"></label>
            <input type="text" id="id" name="id" value="" hidden>

            <!-- Vārda ievade -->
            <label for="name" id="bold">Vārds:</label>
            <input type="text" name="name" placeholder="Ievadi personas vārdu!" id="name"><br><br>

            <!-- Uzvārda ievade -->
            <label for="surname" id="bold">Uzvārds:</label>
            <input type="text" name="surname" placeholder="Ievadi personas uzvārdu!" id="surname"><br><br>

            <!-- Dzimšanas datuma ievade -->
            <label for="birthdate" id="bold">Dzimšanas datums:</label>
            <input type="date" name="birthdate" id="birthdate"><br><br>

            <!-- Vecuma diapazona izvēle -->
            <label for="yearRange" id="bold">Cik jums gadi:</label><br>
            <input type="radio" name="yearRange" value="30">30<br>
            <input type="radio" name="yearRange" value="60">60<br>
            <input type="radio" name="yearRange" value="100">100
        </fieldset><br>

        <fieldset> <!-- Grupē transporta izvēles laukus -->
            <legend id="bold">Trasports</legend><br>
            
            <!-- Auto markas izvēle no saraksta -->
            <label for="carModel" id="bold">izvēlies mīļāko automašīnas marku:</label><br>
            <select name="carModel" id="carModel">
                <option value="" disabled selected>Izvēlies</option>
                <option value="Audi">Audi</option>
                <option value="Volvo">Volvo</option>
                <option value="porsche">porsche</option>
                <option value="Subaru">Subaru</option>
            </select><br><br>

            <!-- Transporta līdzekļu izvēles izvēles rūtiņas -->
            <label for="transport" id="bold">Ar ko jūs pārvietojaties:</label><br>
            <input type="checkbox" name="transport1" value="Bike">Riteni<br>
            <input type="checkbox" name="transport2" value="Car">Mašīnu<br>
            <input type="checkbox" name="transport3" value="Boat">Laivu
        </fieldset><br>

        <!-- Poga datu iesniegšanai -->
        <input type="button" value="Iesniegt" id="btnsubmit" onclick="saveData();">

        <!-- Poga formas datu notīrīšanai -->
        <input type="reset" value="Notīrīt" onclick="document.getElementById('id').value = '';">
    </form><br>

    <!-- Poga jauna ieraksta izveidei (notīra ID lauku) -->
    <input type="reset" value="Jauns" onclick="document.getElementById('id').value = '';">
    
    <script>
        function saveData(){
            // Iegūst ievades lauku vērtības
            var name = document.getElementById('name').value;
            var surname = document.getElementById('surname').value;
            var birthdate = document.getElementById('birthdate').value;
            var yearRange = document.getElementsByName('yearRange').value; // radio poga (šeit gan vajadzētu ciklu, lai iegūtu izvēlēto)
            var carModel = document.getElementById('carModel').value;
            var transport1 = document.getElementsByName('transport1').value;
            var transport2 = document.getElementsByName('transport2').value;
            var transport3 = document.getElementsByName('transport3').value;

            // Pārbauda, vai visi obligātie lauki ir aizpildīti
            if (name === "" || surname === "" || birthdate === "" || yearRange === "" || carModel === "") {
                alert("Lūdzu, aizpildiet visus obligātos laukus!");
                return false; // Ja kaut kas trūkst — pārtrauc darbību
            }
            else {
                // Ja viss ir aizpildīts, iesniedz formu
                document.getElementById('form').submit();
                return true;
            }
        }
    </script>
    <!-- BMD: JavaScript beidzas -->

</body>
</html>
<!-- BMD: HTML dokumenta beigas -->

<?php 
//BMD
    // Iekļauj "izvade.php" failu, kas iespējams parāda vai apstrādā formas datus
    include 'izvade.php';
//BMD
?>
