<?php
$cn = new mysqli("localhost", "root", "", "marks_gutniks");
if ($cn->connect_error) { die("Connection failed: " . $cn->connect_error); }

$ok = false;
$form = ["id"=>"","vards"=>"","uzvards"=>"","datums"=>"","vecums"=>"","transports"=>"","velo"=>0,"auto"=>0,"laiva"=>0];

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id  = isset($_POST["id"]) ? (int)$_POST["id"] : 0;
    $v   = $_POST["vards"] ?? "";
    $u   = $_POST["uzvards"] ?? "";
    $d   = $_POST["datums"] ?? "";
    $ve  = (int)($_POST["vecums"] ?? 0);
    $tr  = $_POST["transports"] ?? "";
    $vl  = isset($_POST["velo"]) ? 1 : 0;
    $au  = isset($_POST["auto"]) ? 1 : 0;
    $la  = isset($_POST["laiva"]) ? 1 : 0;

    if ($id > 0) {
        $q = $cn->prepare("UPDATE person_data SET vards=?, uzvards=?, datums=?, vecums=?, transports=?, velo=?, auto=?, laiva=? WHERE id=?");
        $q->bind_param("sssisiiii", $v, $u, $d, $ve, $tr, $vl, $au, $la, $id);
    } else {
        $q = $cn->prepare("INSERT INTO person_data (vards, uzvards, datums, vecums, transports, velo, auto, laiva) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $q->bind_param("sssisiii", $v, $u, $d, $ve, $tr, $vl, $au, $la);
    }
    $q->execute();
    $q->close();
    $ok = true;
}

if (!$ok && isset($_GET["id"])) {
    $eid = (int)$_GET["id"];
    $s = $cn->prepare("SELECT * FROM person_data WHERE id=?");
    $s->bind_param("i", $eid);
    $s->execute();
    $r = $s->get_result();
    if ($r && $r->num_rows === 1) { $form = $r->fetch_assoc(); } else { die("Dati nav atrasti"); }
    $s->close();
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php if ($ok): ?>
    <script>setTimeout(()=>{location.href="data.php"},10);</script>
    <?php endif; ?>
</head>
<body>
<div<?php echo $ok ? ' style="display:none"' : ''; ?>>
    <form method="POST">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($form['id']); ?>">

        <section>
            <h1>Personas Dati</h1>
            <div>
                <label>Vārds
                    <input type="text" name="vards" value="<?php echo htmlspecialchars($form['vards']); ?>" required>
                </label>
                <label>Uzvārds
                    <input type="text" name="uzvards" value="<?php echo htmlspecialchars($form['uzvards']); ?>" required>
                </label>
                <label>Datums
                    <input type="date" name="datums" value="<?php echo htmlspecialchars($form['datums']); ?>" required>
                </label>
            </div>
        </section>

        <section>
            <h2>Cik Jums ir gadi?</h2>
            <label><input type="radio" name="vecums" value="30"  <?php echo ($form['vecums']!=="" && (int)$form['vecums']<=30) ? 'checked' : ''; ?>> 0-30</label>
            <label><input type="radio" name="vecums" value="60"  <?php echo ((int)$form['vecums']>30 && (int)$form['vecums']<=60) ? 'checked' : ''; ?>> 30-60</label>
            <label><input type="radio" name="vecums" value="100" <?php echo ((int)$form['vecums']>60) ? 'checked' : ''; ?>> 60-100</label>
        </section>

        <section>
            <h2>Transports</h2>
            <label for="cars">Mīļākā auto marka</label>
            <select id="cars" name="transports">
                <option value="volvo" <?php echo ($form['transports']==='volvo') ? 'selected' : ''; ?>>Volvo</option>
                <option value="bmw"   <?php echo ($form['transports']==='bmw') ? 'selected' : ''; ?>>BMW</option>
                <option value="audi"  <?php echo ($form['transports']==='audi') ? 'selected' : ''; ?>>Audi</option>
            </select>

            <h3>Ar ko jūs pārvietojaties:</h3>
            <label><input type="checkbox" name="velo"  <?php echo $form['velo']  ? 'checked' : ''; ?>> Ar Divriteni</label>
            <label><input type="checkbox" name="auto"  <?php echo $form['auto']  ? 'checked' : ''; ?>> Ar Auto</label>
            <label><input type="checkbox" name="laiva" <?php echo $form['laiva'] ? 'checked' : ''; ?>> Ar Laivu</label>
        </section>

        <div>
            <button type="submit">Saglabāt</button>
            <button type="button" onclick="location.href='data.php'">Atcelt</button>
        </div>
    </form>
</div>
</body>
</html>
