<?php
$cn = new mysqli("localhost", "root", "", "marks_gutniks");
if ($cn->connect_error) { die("Connection failed: " . $cn->connect_error); }

$deleted = false;

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["delete_id"])) {
    $did = (int)$_POST["delete_id"];
    $del = $cn->prepare("DELETE FROM person_data WHERE id=?");
    $del->bind_param("i", $did);
    $del->execute();
    $del->close();
    $deleted = true;
}

$res = $cn->query("SELECT id, vards, uzvards, datums, vecums, transports, velo, auto, laiva FROM person_data ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php if ($deleted): ?>
    <script>setTimeout(()=>{location.href="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>"},10);</script>
    <?php endif; ?>
    <style>
        table, th, tr, td { border: 1px solid black;}
    </style>
</head>
<body>
<div<?php echo $deleted ? ' style="display:none"' : ''; ?>>
    <div>
        <button onclick="location.href='index.php'">Jauns</button>
    </div>

    <table>
        <thead>
            <tr>
                <th colspan="4">Personas</th>
                <th colspan="2">Transports</th>
                <th rowspan="2">Darbības</th>
            </tr>
            <tr>
                <th>Vārds</th>
                <th>Uzvārds</th>
                <th>Dzimšanas datums</th>
                <th>Gadi</th>
                <th>Mašīna</th>
                <th>Pārvietošanās</th>
            </tr>
        </thead>
        <tbody>
        <?php
        if ($res && $res->num_rows > 0) {
            while ($row = $res->fetch_assoc()) {
                $moves = [];
                if ((int)$row["velo"]  === 1) $moves[] = "Velo";
                if ((int)$row["auto"]  === 1) $moves[] = "Auto";
                if ((int)$row["laiva"] === 1) $moves[] = "Laiva";
                $movesStr = htmlspecialchars(implode(" ", $moves));

                $id = (int)$row["id"];
                $v  = htmlspecialchars($row["vards"]);
                $u  = htmlspecialchars($row["uzvards"]);
                $d  = htmlspecialchars($row["datums"]);
                $g  = htmlspecialchars($row["vecums"]);
                $t  = htmlspecialchars($row["transports"]);

                echo "<tr>";
                echo "<td>{$v}</td>";
                echo "<td>{$u}</td>";
                echo "<td>{$d}</td>";
                echo "<td>{$g}</td>";
                echo "<td>{$t}</td>";
                echo "<td>{$movesStr}</td>";
                echo "<td>
                        <form method='GET' action='index.php' style='display:inline'>
                            <input type='hidden' name='id' value='{$id}'>
                            <button type='submit'>Labot</button>
                        </form>
                        <form method='POST' style='display:inline' onsubmit='return'>
                            <input type='hidden' name='delete_id' value='{$id}'>
                            <button type='submit'>Dzēst</button>
                        </form>
                      </td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><td colspan='7'>Nav datu</td></tr>";
        }
        $cn->close();
        ?>
        </tbody>
    </table>
</div>
</body>
</html>
