using System;

class Program
{
    static void Main()
    {
        // Saglabā vārdu un uzvārdu
        string persona = "RIHARDS LAPINS";

        // Izvada vārdu un uzvārdu ar pirmo burtu lielo
        Console.WriteLine("Vards: " + FormatName(persona.Split(' ')[0]));
        Console.WriteLine("Uzvards: " + FormatName(persona.Split(' ')[1]));

        // Pieprasa ievadīt rindu un kolonu skaitu (ne mazāk par 5)
        int rindas, kolonas;
        do Console.Write("Ievadiet rindu skaitu, ne mazak ka 5: "); 
        while (!int.TryParse(Console.ReadLine(), out rindas) || rindas < 5);
        
        do Console.Write("Ievadiet kolonu skaitu, ne mazak ka 5: "); 
        while (!int.TryParse(Console.ReadLine(), out kolonas) || kolonas < 5);

        // Izveido labi līdzinātu kāpņu veida tabulu
        for (int i = 1; i <= rindas; i++)
        {
            // Pievieno atstarpes labajai līdzināšanai
            Console.Write(new string(' ', (kolonas - Math.Min(i, kolonas)) * 4));

            // Zīmē horizontālo rāmju līniju
            for (int j = 1; j <= Math.Min(i, kolonas); j++) 
                Console.Write("+---");
            Console.WriteLine("+");

            // Pievieno atstarpes labajai līdzināšanai
            Console.Write(new string(' ', (kolonas - Math.Min(i, kolonas)) * 4));

            // Ievieto skaitļus šūnās
            for (int j = 1; j <= kolonas; j++)
            {
                if (j > kolonas - Math.Min(i, kolonas)) 
                {
                    int number = i - (kolonas - j);
                    PrintCell(number);
                    Console.Write(" ");
                }
                else 
                {
                    Console.Write("");
                }
            }
            Console.WriteLine("|");
        }

        // Zīmē pēdējo horizontālo rāmju līniju
        for (int j = 1; j <= Math.Min(rindas, kolonas); j++) 
            Console.Write("+---");
        Console.WriteLine("+");
    }

    // Palīgfunkcija vārda formatēšanai (pirmais burts lielais)
    static string FormatName(string name)
    {
        return char.ToUpper(name[0]) + name.Substring(1).ToLower();
    }

    // Palīgfunkcija šūnas satura izvadei
    static void PrintCell(int number)
    {
        if (number >= 10)
            Console.Write($"|{number}");
        else
            Console.Write($"| {number}");
    }
}