<?php
$conn = new mysqli("localhost", "root", "", "characters_data");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$row = [
    "id" => "",
    "vards" => "",
    "uzvards" => "",
    "datums" => "",
    "vecums" => "",
    "transports" => "",
    "velo" => 0,
    "auto" => 0,
    "laiva" => 0
];

$success = false;

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $id       = isset($_POST["id"]) ? intval($_POST["id"]) : 0;
    $vards    = $_POST["vards"];
    $uzvards  = $_POST["uzvards"];
    $datums   = $_POST["datums"];
    $vecums   = intval($_POST["vecums"]);
    $trans    = $_POST["transports"];
    $velo     = isset($_POST["velo"]) ? 1 : 0;
    $auto     = isset($_POST["auto"]) ? 1 : 0;
    $laiva    = isset($_POST["laiva"]) ? 1 : 0;

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE person_data 
                                SET vards=?, uzvards=?, datums=?, vecums=?, transports=?, velo=?, auto=?, laiva=? 
                                WHERE id=?");
        $stmt->bind_param("sssisiiii", $vards, $uzvards, $datums, $vecums, $trans, $velo, $auto, $laiva, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO person_data (vards, uzvards, datums, vecums, transports, velo, auto, laiva) 
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssisiii", $vards, $uzvards, $datums, $vecums, $trans, $velo, $auto, $laiva);
    }

    $stmt->execute();
    $stmt->close();
    $success = true;
}

if (isset($_GET["id"])) {
    $id = intval($_GET["id"]);
    $result = $conn->query("SELECT * FROM person_data WHERE id=$id");
    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
    } else {
        die("Dati nav atrasti");
    }
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($_GET["id"]) ? "Labot datus" : "Pievienot jaunu"; ?></title>
    <link rel="stylesheet" href="style.css?v=<?php echo time(); ?>">
    <style>
        .ft-green-tick .tick {
            stroke-dasharray: 50;
            stroke-dashoffset: 50;
            animation: draw 0.6s forwards 0.2s;
        }
        @keyframes draw {
            to { stroke-dashoffset: 0; }
        }
        .svg-container { text-align: center; margin-top: 50px; }
    </style>
    <?php if($success): ?>
    <script>
        setTimeout(() => {
            window.location.href = "data.php";
        }, 2000);
    </script>
    <?php endif; ?>
</head>
<body>

<div class="svg-container" style="display: <?php echo $success ? 'block' : 'none'; ?>;">    
    <svg class="ft-green-tick" xmlns="http://www.w3.org/2000/svg" height="100" width="100" viewBox="0 0 48 48">
        <circle class="circle" fill="#5bb543" cx="24" cy="24" r="22"/>
        <path class="tick" fill="none" stroke="#FFF" stroke-width="6" stroke-linecap="round" stroke-linejoin="round" d="M14 27l5.917 4.917L34 17"/>
    </svg>
    <p style="color: #5bb543; font-size: 18px; font-weight: 500;">Dati veiksmīgi saglabāti!</p>
</div>

<div class="container" style="display: <?php echo $success ? 'none' : 'block'; ?>;">
    <form method="POST">
        <h1>Personas Dati</h1>
        <input type="hidden" name="id" value="<?php echo $row['id']; ?>">

        <div class="input">
            <input type="text" name="vards" value="<?php echo htmlspecialchars($row['vards']); ?>" placeholder="Vārds" required>
            <input type="text" name="uzvards" value="<?php echo htmlspecialchars($row['uzvards']); ?>" placeholder="Uzvārds" required>
            <input type="date" name="datums" value="<?php echo $row['datums']; ?>" required>
        </div>

        <h2>Cik Jums ir gadi?</h2>
        <div class="age">
            <label><input type="radio" name="vecums" value="30" <?php if($row['vecums']<=30) echo 'checked'; ?>> 0-30</label>
            <label><input type="radio" name="vecums" value="60" <?php if($row['vecums']>30 && $row['vecums']<=60) echo 'checked'; ?>> 30-60</label>
            <label><input type="radio" name="vecums" value="100" <?php if($row['vecums']>60) echo 'checked'; ?>> 60-100</label>
        </div>

        <div class="transport">
            <h2 class="section">Transports</h2>
            <div class="favcar">
                <label for="cars">Izvēlieties mīļāko auto marku:</label>
                <select id="cars" name="transports">
                    <option value="volvo" <?php if($row['transports']=='volvo') echo 'selected'; ?>>Volvo</option>
                    <option value="bmw" <?php if($row['transports']=='bmw') echo 'selected'; ?>>BMW</option>
                    <option value="audi" <?php if($row['transports']=='audi') echo 'selected'; ?>>Audi</option>
                    <option value="lamborghini" <?php if($row['transports']=='lamborghini') echo 'selected'; ?>>Lamborghini</option>
                    <option value="porsche" <?php if($row['transports']=='porsche') echo 'selected'; ?>>Porsche</option>
                </select>
            </div>

            <h2>Ar ko jūs pārvietojaties: </h2>
            <div class="optionstrans">
                <label><input type="checkbox" name="velo" <?php if($row['velo']) echo 'checked'; ?>> Ar Divriteni</label>
                <label><input type="checkbox" name="auto" <?php if($row['auto']) echo 'checked'; ?>> Ar Auto</label>
                <label><input type="checkbox" name="laiva" <?php if($row['laiva']) echo 'checked'; ?>> Ar Laivu</label>
            </div>
        </div>

        <div class="buttons">
            <button type="submit" class="submit">Saglabāt</button>
            <button class="delete" type="button" onclick="window.location.href='data.php'">Atcelt</button>
        </div>
    </form>
</div>

<script>
    let path = document.querySelector(".tick");
    let length = path.getTotalLength();
    console.log(length);  
</script>
</body>
</html>
