<?php
$conn = new mysqli("localhost", "root", "", "characters_data");
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$deleted = false;

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["delete_id"])) {
    $delete_id = intval($_POST["delete_id"]);
    $stmt = $conn->prepare("DELETE FROM person_data WHERE id = ?");
    $stmt->bind_param("i", $delete_id);
    $stmt->execute();
    $stmt->close();
    $deleted = true;
}
?>
<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dati no SQL</title>
    <link rel="stylesheet" href="styledata.css?v=<?php echo time(); ?>">
    <style>
        .ft-green-tick .tick {
            stroke-dasharray: 50;
            stroke-dashoffset: 50;
            animation: draw 0.6s forwards 0.2s;
        }
        @keyframes draw {
            to { stroke-dashoffset: 0; }
        }
        .svg-container { text-align: center; margin-top: 50px; }
    </style>
    <?php if($deleted): ?>
        <script>
            setTimeout(() => {
                window.location.href = "<?php echo $_SERVER['PHP_SELF']; ?>";
            }, 2000);
        </script>
    <?php endif; ?>
</head>
<body>

<div class="svg-container" style="display: <?php echo $deleted ? 'block' : 'none'; ?>;">    
    <svg class="ft-green-tick" xmlns="http://www.w3.org/2000/svg" height="100" width="100" viewBox="0 0 48 48">
        <circle class="circle" cx="24" cy="24" r="22"/>
        <path class="tick" d="M14 27l5.917 4.917L34 17"/>
    </svg>
    <p style="color: #5bb543; font-size: 18px; font-weight: 500;">Dati veiksmīgi dzēsti!</p>
</div>

<div class="container" style="display: <?php echo $deleted ? 'none' : 'block'; ?>;">
    <button class="top-btn" onclick="window.location.href='index.php'">Jauns</button>

    <?php
    $sql = "SELECT id, vards, uzvards, datums, vecums, transports, velo, auto, laiva FROM person_data";
    $result = $conn->query($sql);
    ?>

    <table>
        <thead>
            <tr>
                <th colspan="4" class="group-header">Personas</th>
                <th colspan="2" class="group-header">Transports</th>
                <th rowspan="2" class="group-header">Darbības</th>
            </tr>
            <tr>
                <th>Vārds</th>
                <th>Uzvārds</th>
                <th>Dzimšanas datums</th>
                <th>Gadi</th>
                <th>Mašīna</th>
                <th>Pārvietošanās</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result && $result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row["vards"]) . "</td>";
                    echo "<td>" . htmlspecialchars($row["uzvards"]) . "</td>";
                    echo "<td>" . htmlspecialchars($row["datums"]) . "</td>";
                    echo "<td>" . htmlspecialchars($row["vecums"]) . "</td>";
                    echo "<td>" . htmlspecialchars($row["transports"]) . "</td>";

                    echo "<td>";
                    if ($row["velo"])  echo "<span>Velo</span> ";
                    if ($row["auto"])  echo "<span>Auto</span> ";
                    if ($row["laiva"]) echo "<span>Laiva</span> ";
                    echo "</td>";

                    echo "<td>
                            <form method='GET' action='index.php' style='display:inline'>
                                <input type='hidden' name='id' value='" . $row["id"] . "'>
                                <button type='submit'>Labot</button>
                            </form>
                            <form method='POST' style='display:inline'>
                                <input type='hidden' name='delete_id' value='" . $row["id"] . "'>
                                <button type='submit' class='delete' onclick='return confirm(\"Vai tiešām dzēst?\")'>Dzēst</button>
                            </form>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='7'>Nav datu</td></tr>";
            }

            $conn->close();
            ?>
        </tbody>
    </table>
</div>  
</body>
</html>
