<?php
// --- DATABASE CONNECTION ---
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "rodrigo"; // change if needed

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Neizdevās savienoties ar DB: " . $conn->connect_error);
}

// --- GET ALL PERSONAS ---
$sql = "SELECT * FROM personas";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        table, th, td { border: 1px solid black; border-collapse: collapse; padding: 5px; }
        th { background-color: #eee; }
        button { margin: 2px; }
    </style>
    <title>Personu dati</title>
</head>
<body>
    <h1>Visas personas</h1>
    <button onclick="location.href='index.php'">Pievienot jaunu</button>

    <table>
        <thead>
            <tr>
                <th colspan="4">Personas</th>
                <th colspan="2">Transports</th>
                <th>Darbības</th>
            </tr>
            <tr>
                <th>Vārds</th>
                <th>Uzvārds</th>
                <th>Dzimšanas datums</th>
                <th>Gadi</th>
                <th>Mašīna</th>
                <th>Pārvietošanās</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($row['vards']) ?></td>
                        <td><?= htmlspecialchars($row['uzvards']) ?></td>
                        <td><?= htmlspecialchars($row['datums']) ?></td>
                        <td><?= htmlspecialchars($row['vecums']) ?></td>
                        <td><?= htmlspecialchars($row['transports']) ?></td>
                        <td>
                            <?php
                                $moves = [];
                                if ($row['velo']) $moves[] = 'Divritenis';
                                if ($row['auto']) $moves[] = 'Auto';
                                if ($row['laiva']) $moves[] = 'Laiva';
                                echo implode(', ', $moves);
                            ?>
                        </td>
                        <td>
                            <button onclick="location.href='index.php?id=<?= $row['id'] ?>'">Rediģēt</button>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="7">Nav datu</td></tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>
