<?php
include 'conn.php';

$sql = "SELECT id, vards, uzvards, dzimene, vecums, intereses, transports, dzimums, masinas FROM rihards";
$result = $conn->query($sql);

if (!$result) {
  die("Query failed: " . $conn->error);
}
?>

<!DOCTYPE html>
<html>
  <head>
    <title>Lietotāji</title>
    <meta charset="UTF-8">
  </head>
  <script src="filter.js"></script>
  <body>
    <h1>Tablis</h1>
    <form action="ievade.php">
      <button type="submit">Jauns lietotājs</button>
    </form>
    <input id="ievade" placeholder="Meklēt visā tabulā..." style="display: inline;">
    <br>
    <table border="1">
      <thead>
        <th>ID</th>
        <th>Vārds</th>
        <th>Uzvārds</th>
        <th>Dzimšanas datums</th>
        <th>Vecums</th>
        <th>Intereses</th>
        <th>Pārvietošanās</th>
        <th>Mašīnas</th>
        <th>Dzimums</th>
        <th>Darbības</th>
      </thead>
      <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= $row['id'] ?></td>
            <td><?= $row['vards'] ?></td>
            <td><?= $row['uzvards'] ?></td>
            <td><?= $row['dzimene'] ?></td>
            <td><?= $row['vecums'] ?></td>
            <td><?= $row['intereses'] ?></td>
            <td><?= $row['transports'] ?></td>
            <td>
              <?php if ($row['transports'] == 'Mašīna') {
                echo $row['masinas'];
              } else {
                echo '-';
              } ?>
            </td>
            <td><?= $row['dzimums'] ?></td>
            <td>
              <form action="edit.php" style="display: inline;">
                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                <input type="submit" value="Labot">
              </form>
              <form action="del.php" style="display: inline;">
                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                <input type="submit" value="Dzēst">
              </form>
            </td>
        <?php endwhile; ?>
      </tbody>
    </table>
    <?php $conn->close(); ?>
  </body>
</html>
