using System;

class Program
{
    static void Main()
    {
        // Definējam mainīgos vārdu un uzvārdu
        string vards = "Rihards";
        string uzvards = "Lapins";
        
        // Izvadam vārdu un tā garumu (ar lielo sākumburtu)
        Console.WriteLine($"Mans vards ir {CapitalizeFirstLetter(vards)} un taja ir {vards.Length} simboli");
        
        // Izvadam uzvārdu un tā garumu (ar lielo sākumburtu)
        Console.WriteLine($"Mans uzvards ir {CapitalizeFirstLetter(uzvards)} un taja ir {uzvards.Length} simboli");
        Console.WriteLine();
        
        // Izsaucam tabulas izdrukas funkciju
        PrintTable(vards, uzvards);
    }
    
    // Funkcija, kas pārveido pirmo burtu par lielo, pārējos par mazajiem
    static string CapitalizeFirstLetter(string word)
    {
        // Pārbauda, vai vārds nav tukšs vai null
        if (string.IsNullOrEmpty(word))
            return word;
            
        // Pārveido pirmo burtu par lielo un pārējos par mazajiem
        return char.ToUpper(word[0]) + word.Substring(1).ToLower();
    }
    
    // Galvenā funkcija tabulas izveidei un aizpildei
    static void PrintTable(string vards, string uzvards)
    {
        // Nosaka minimālo un maksimālo vērtību diapazonu
        int minValue = vards.Length;
        int maxValue = vards.Length + uzvards.Length;
        
        // Inicializē nejaušo skaitļu ģeneratoru
        Random rnd = new Random();
        
        // Iekšējā funkcija horizontālo līniju zīmēšanai
        void DrawHorizontalLine()
        {
            // Zīmē tabulas kreiso malu
            Console.Write("+-----+");
            
            // Zīmē kolonnas katram vārda burtam
            for (int i = 0; i < vards.Length; i++)
            {
                Console.Write("-----+");
            }
            
            // Zīmē aprēķinu kolonnas
            Console.Write("-----+-----+-----+-----+");
            Console.WriteLine();
        }
        
        // Zīmē augšējo robežlīniju
        DrawHorizontalLine();
        
        // Izveido virsraksta rindu
        Console.Write("|  x  |");  // Pirmā kolonna
        
        // Aizpilda kolonnas ar vārda burtiem (lielajiem)
        for (int i = 0; i < vards.Length; i++)
        {
            Console.Write($"  {char.ToUpper(vards[i]).ToString().PadRight(3)}|");
        }
        
        // Pievieno aprēķinu kolonnu virsrakstus
        Console.Write(" max | min | vid | sum |");
        Console.WriteLine();
        
        // Zīmē līniju aiz virsraksta rindas
        DrawHorizontalLine();
        
        // Aizpilda tabulu ar datiem katram uzvārda burtam
        for (int i = 0; i < uzvards.Length; i++)
        {
            // Pašreizējais uzvārda burts (mazais)
            char currentChar = char.ToLower(uzvards[i]);
            
            // Masīvs vērtībām šai rindai
            int[] values = new int[vards.Length];
            int sum = 0;
            int max = 0;
            int min = 100;
            
            // Sāk jaunu rindu ar uzvārda burtu
            Console.Write($"|  {currentChar}  |");
            
            // Ģenerē vērtības un aizpilda rindu
            for (int j = 0; j < vards.Length; j++)
            {
                // Nejauša vērtība noteiktā diapazonā
                values[j] = rnd.Next(minValue, maxValue + 1);
                
                // Aprēķina summu
                sum += values[j];
                
                // Atrod maksimālo vērtību
                if (values[j] > max) max = values[j];
                
                // Atrod minimālo vērtību
                if (values[j] < min) min = values[j];
                
                // Izvada vērtību (izlīdzinātu pa labi)
                Console.Write($" {values[j].ToString().PadLeft(3)} |");
            }
            
            // Aprēķina vidējo vērtību (1 cipars aiz komata)
            double vid = Math.Round((double)sum / vards.Length, 1);
            string vidString = vid.ToString("0.0");
            
            // Izvada aprēķinu rezultātus (pareizi izlīdzinātus)
            Console.Write($" {max.ToString().PadLeft(3)} | {min.ToString().PadLeft(3)} |{vidString.PadLeft(5)}| {sum.ToString().PadLeft(3)} |");
            Console.WriteLine();
            
            // Zīmē horizontālo līniju pēc katras rindas
            DrawHorizontalLine();
        }
    }
}