// Parāda vai paslēpj "Mašīnas" ievades lauku
function handleTransportField() {
  const transportValue = document.querySelector("#transports").value;
  const carField = document.querySelector("#masinasField");
  carField.style.display = transportValue === "Mašīna" ? "block" : "none";
}

let currentEvent = null;

// Validācijas pārbaudes funkcija
function validateInput(target, label) {
  // Ja tiek padots saraksts (piemēram, checkbox)
  if (NodeList.prototype.isPrototypeOf(target)) {
    const checked = Array.from(target).some((el) => el.checked);
    if (!checked) {
      displayError(`${label} jāizvēlas vismaz viena lieta!`, target);
      return false;
    }
    return true;
  }

  const rawValue = target.value.trim();

  // Tukšs lauks
  if (rawValue === "") {
    displayError(`${label} nedrīkst būt tukšs!`, target);
    return false;
  }

  // Teksta ievades minimālais garums
  if (target.type === "text" && rawValue.length < 5) {
    displayError(`${label} jābūt vismaz 5 rakstzīmes garam!`, target);
    return false;
  }

  // Datuma validācija
  if (target.type === "date") {
    const entered = new Date(rawValue);
    const today = new Date();

    entered.setHours(0, 0, 0, 0);
    today.setHours(0, 0, 0, 0);

    if (entered > today) {
      displayError("Datums nevar būt nākotnē!", target);
      return false;
    }

    const limitDate = new Date(today);
    limitDate.setFullYear(today.getFullYear() - 20);

    if (entered < limitDate) {
      displayError("Datums nevar būt vecāks par 20 gadiem!", target);
      return false;
    }

    return true;
  }

  // Teksta formatēšana
  let formatted = rawValue.toLowerCase();
  formatted = formatted.replace(
    /(^|[\s-])([a-z])/g,
    (_, prefix, letter) => prefix + letter.toUpperCase(),
  );
  target.value = formatted;

  return true;
}

// Kļūdas ziņojuma un stilu piešķiršana
function displayError(message, target = null) {
  if (currentEvent) currentEvent.preventDefault();
  alert(message);

  if (!target) return;

  const highlight = (el) => {
    el.style.outline = "3px solid red";
    el.style.backgroundColor = "#ff0000";
  };

  if (NodeList.prototype.isPrototypeOf(target)) {
    for (const el of target) highlight(el);
  } else {
    target.style.border = "3px solid red";
    target.style.backgroundColor = "#ff0000";
  }
}

// Kad lapa ir pilnībā ielādēta
document.addEventListener("DOMContentLoaded", () => {
  const form = document.querySelector("form");

  form.addEventListener("submit", (e) => {
    // Atiestata vizuālos stilus
    const allInputs = form.querySelectorAll("input, select");
    for (const field of allInputs) {
      field.style.border = "";
      field.style.backgroundColor = "";
      field.style.outline = "";
    }

    let valid = true;
    currentEvent = e;

    const fields = {
      vards: ["Vārds", document.querySelector("#vards")],
      uzvards: ["Uzvārds", document.querySelector("#uzvards")],
      dzimene: ["Dzimene", document.querySelector("#dzimene")],
      vecums: ["Vecums", document.querySelector("#vecums")],
      intereses: [
        "Intereses",
        document.querySelectorAll("input[name='intereses[]']"),
      ],
      transports: ["Transports", document.querySelector("#transports")],
      dzimums: ["Dzimums", document.querySelector("#dzimums")],
    };

    for (const key in fields) {
      const [label, el] = fields[key];
      if (!validateInput(el, label)) valid = false;
    }

    if (!valid) e.preventDefault();
  });
});
