// Kārto tabulu pēc izvēlētās kolonnas
function reorderTable(bodyElement, columnIndex) {
  const rows = [...bodyElement.querySelectorAll("tr")];
  const ascending = bodyElement.dataset.sortDir !== "asc";

  rows.sort((rowA, rowB) => {
    const valA = rowA.children[columnIndex].textContent.trim();
    const valB = rowB.children[columnIndex].textContent.trim();

    const bothNumbers = !isNaN(valA) && !isNaN(valB);
    if (bothNumbers) {
      return ascending ? valA - valB : valB - valA;
    }

    return ascending ? valA.localeCompare(valB) : valB.localeCompare(valA);
  });

  // Pārkārto rindas tabulā
  for (const r of rows) bodyElement.appendChild(r);

  // Saglabā kārtošanas virzienu
  bodyElement.dataset.sortDir = ascending ? "asc" : "desc";
}

document.addEventListener("DOMContentLoaded", () => {
  const table = document.querySelector("table");
  const headers = table.querySelectorAll("th");
  const tableBody = table.querySelector("tbody");
  const searchBox = document.querySelector("input");

  // Kārtošanas funkcija kolonnām
  for (let index = 0; index < headers.length; index++) {
    const headerCell = headers[index];
    headerCell.style.cursor = "pointer";
    headerCell.addEventListener("click", () => reorderTable(tableBody, index));
  }

  // Filtrēšanas funkcija ievades laukam
  searchBox.addEventListener("input", (e) => {
    const query = e.target.value.toLowerCase();

    for (const row of tableBody.querySelectorAll("tr")) {
      const visible = row.textContent.toLowerCase().includes(query);
      row.style.display = visible ? "" : "none";
    }
  });
});
