using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        // Ievada teikumu no lietotāja
        Console.Write("Ievadi teikumu: ");
        string input = Console.ReadLine();

        // Izvada vārdus apgrieztā secībā ar pareizu lielo burtu
        Console.Write("Samainiti vardi: ");
        string reversedWords = ReverseWords(input);
        Console.WriteLine(reversedWords);
        
        // Izvada apgrieztus burtus vārdos ar pareizu lielo burtu
        Console.Write("Samainiti burti vardos: ");
        string reversedText = ReverseText(input);
        Console.WriteLine(reversedText);
        
        // Veic visus vizuālos efekta attēlojumus
        CenteredOutput(input);            // Veido piramīd-veidīgu figuru
        ReplaceFromMiddle(input);         // Veido figuru pilnīgi pretēju pirmai
        RevealFromEnd(input);             // Veido "trepītes" no labās puses
        RevealFromStartUpsideDown(input); // Veido "trepītes" no kreisās puses un apgriestā veidā
    }
    
    // Funkcija, kas apgriež vārdu secību teikumā
    static string ReverseWords(string text)
    {
        // Sadala teikumu vārdos
        var words = text.Split(' ');
        // Apgriež vārdu secību
        Array.Reverse(words);
        
        // Pārveido pirmo vārdu ar lielo sākumburtu, pārējos ar mazajiem
        if (words.Length > 0)
        {
            words[0] = CapitalizeFirstLetter(words[0]);
            for (int i = 1; i < words.Length; i++)
            {
                words[i] = words[i].ToLower();
            }
        }
        
        // Savieno vārdus atpakaļ teikumā
        return string.Join(" ", words);
    }
    
    // Funkcija, kas apgriež burtus katrā vārdā
    static string ReverseText(string text)
    {
        // Sadala teikumu vārdos un apgriež burtus katrā vārdā
        var words = text.Split(' ')
                        .Select(word => new string(word.Reverse().ToArray()))
                        .ToArray();
        
        // Pārveido pirmo vārdu ar lielo sākumburtu, pārējos ar mazajiem
        if (words.Length > 0)
        {
            words[0] = CapitalizeFirstLetter(words[0]);
            for (int i = 1; i < words.Length; i++)
            {
                words[i] = words[i].ToLower();
            }
        }
        
        // Savieno vārdus atpakaļ teikumā
        return string.Join(" ", words);
    }
    
    // Palīgfunkcija, kas pārveido vārda pirmo burtu par lielo, pārējos par mazajiem
    static string CapitalizeFirstLetter(string word)
    {
        if (string.IsNullOrEmpty(word))
            return word;
            
        return char.ToUpper(word[0]) + word.Substring(1).ToLower();
    }
    
    // Funkcija, kas attēlo tekstu centrēti, paplašinot no centra
    static void CenteredOutput(string text)
    {
        int middle = text.Length / 2;
        StringBuilder output = new StringBuilder();
        
        for (int i = 0; i <= middle; i++)
        {
            int left = middle - i;
            int right = middle + i;
            
            output.Clear();
            
            // Aizpilda ar atstarpēm un atstāj redzamu tikai pašreizējo daļu
            for (int j = 0; j < text.Length; j++)
            {
                if (j >= left && j <= right)
                    output.Append(text[j]);
                else
                    output.Append(' ');
            }
            Console.WriteLine(output);
        }
    }
    
    // Funkcija, kas aizvieto tekstu ar atstarpēm, sākot no centra
    static void ReplaceFromMiddle(string text)
    {
        char[] chars = text.ToCharArray();
        int left = text.Length / 2;
        int right = (text.Length % 2 == 0) ? left - 1 : left;
        
        // Aizvieto rakstzīmes ar atstarpēm, virzoties uz āru no centra
        while (left >= 0 && right < text.Length)
        {
            chars[left] = ' ';
            chars[right] = ' ';
            Console.WriteLine(new string(chars));
            left--;
            right++;
        }
    }
    
    // Funkcija, kas atklāj tekstu no beigām uz sākumu
    static void RevealFromEnd(string text)
    {
        StringBuilder output = new StringBuilder(new string(' ', text.Length));
        
        // Aizpilda no beigām uz sākumu
        for (int i = text.Length - 1; i >= 0; i--)
        {
            output[i] = text[i];
            Console.WriteLine(output);
        }
    }
    
    // Funkcija, kas atklāj tekstu no sākuma uz beigām, bet izvada apgrieztā secībā
    static void RevealFromStartUpsideDown(string text)
    {
        StringBuilder output = new StringBuilder();
        var lines = new List<string>();

        // Uzkrāj katru soli sarakstā
        for (int i = 0; i < text.Length; i++)
        {
            output.Append(text[i]);
            lines.Add(output.ToString());
        }

        // Izvada apgrieztā secībā
        for (int i = lines.Count - 1; i >= 0; i--)
        {
            Console.WriteLine(lines[i]);
        }
    }
}