using System;

class Program
{
    static void Main()
    {
        // Saglabā vārdu un uzvārdu
        string persona = "RIHARDS LAPINS";

        // Izvada vārdu ar pirmo burtu lielo, pārējiem mazajiem
        Console.WriteLine("Vards: " + FormatName(persona.Split(' ')[0]));
        
        // Izvada uzvārdu ar pirmo burtu lielo, pārējiem mazajiem
        Console.WriteLine("Uzvards: " + FormatName(persona.Split(' ')[1]));

        // Pieprasa lietotājam ievadīt kolonu skaitu (vismaz 5)
        int kolonas;
        do 
        {
            Console.Write("Ievadi kolonu skaitu, ne mazak ka 5: ");
        } 
        while (!int.TryParse(Console.ReadLine(), out kolonas) || kolonas < 5);

        // Zīmē augšējo kāpņu daļu
        DrawUpperStairs(kolonas);
        
        // Zīmē horizontālo atdalošo līniju
        DrawHorizontalLine(kolonas, 0);
        
        // Zīmē apakšējo kāpņu daļu
        DrawLowerStairs(kolonas);
        
        // Zīmē pēdējo horizontālo līniju
        DrawHorizontalLine(kolonas, 0);
    }

    // Palīgfunkcija vārda formatēšanai (pirmais burts lielais, pārējie mazie)
    static string FormatName(string name)
    {
        return char.ToUpper(name[0]) + name.Substring(1).ToLower();
    }

    // Funkcija horizontālas līnijas zīmēšanai
    static void DrawHorizontalLine(int columns, int indent)
    {
        Console.Write(new string(' ', indent * 4));
        for (int j = 1; j <= columns; j++) 
        {
            Console.Write("+---");
        }
        Console.WriteLine("+");
    }

    // Funkcija šūnas satura zīmēšanai
    static void DrawCellContent(int number)
    {
        if (number >= 10)
            Console.Write($"|{number}");
        else
            Console.Write($"| {number}");
    }

    // Funkcija augšējās kāpņu daļas zīmēšanai
    static void DrawUpperStairs(int kolonas)
    {
        for (int i = 1; i <= kolonas; i++)
        {
            // Atkāpes no kreisās puses
            Console.Write(new string(' ', (kolonas - i) * 4));
            
            // Zīmē horizontālo līniju
            DrawHorizontalLine(i, 0);
            
            // Atkāpes no kreisās puses
            Console.Write(new string(' ', (kolonas - i) * 4));
            
            // Zīmē šūnu saturu
            for (int j = 1; j <= i; j++)
            {
                DrawCellContent(j);
                Console.Write(" ");
            }
            Console.WriteLine("|");
        }
    }

    // Funkcija apakšējās kāpņu daļas zīmēšanai
    static void DrawLowerStairs(int kolonas)
    {
        for (int i = 1; i <= kolonas; i++)
        {
            // Zīmē horizontālo līniju (izņemot pirmo iterāciju)
            if (i != 1)
            {
                DrawHorizontalLine(i, 0);
            }

            // Zīmē šūnu saturu
            for (int j = 1; j <= i; j++)
            {
                DrawCellContent(j);
                Console.Write(" ");
            }
            Console.WriteLine("|");
        }
    }
}